/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Rpc(name="test.trace", export=true)
class RpcTrace {
    private static Log log = LogFactory.getLog(RpcTrace.class);
    private static long monitorID;
    public static boolean isRealtime;
    static RpcTrace instance;
    private static String newline;
    private static SimpleDateFormat formater;
    private static ExecutorService pool;

    RpcTrace() {
    }

    static void setLog(Log mock) {
        log = mock;
    }

    public void launch(RpcContext ctx) {
        monitorID = ctx.getClientID();
        if (ctx.getServletRequest() == null) {
            isRealtime = true;
        }
    }

    public void suspend(RpcContext ctx) {
        if (ctx.getServletRequest() == null) {
            isRealtime = false;
        }
        this.closePool();
    }

    synchronized void startPool() {
        if (pool == null) {
            pool = Executors.newCachedThreadPool();
            log.warn((Object)"RpcTrace startPool");
        }
    }

    synchronized void closePool() {
        if (pool != null) {
            pool.shutdown();
            pool = null;
            log.warn((Object)"RpcTrace closePool");
        }
    }

    protected void push(HttpServletRequest req, RpcMessage msg, boolean bool) {
        pool.submit(new RpcPusher(req, msg, bool));
    }

    protected void push(SocketConnection connection, RpcSocketPDU msg, boolean bool) {
        pool.submit(new RpcPusher(connection, msg, bool));
    }

    public static RpcTrace getInstance() {
        if (instance == null) {
            instance = new RpcTrace();
        }
        instance.startPool();
        return instance;
    }

    static String getRemoteSocketAddress(SocketConnection conn) {
        SocketConnector connector = conn.getConnector();
        String host = conn.getSocketChannel().socket().getRemoteSocketAddress().toString();
        return connector.getProtocol().getSchema() + ":/" + host;
    }

    static String getURI(SocketConnection conn) {
        try {
            return conn.getConnector().getURI().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static void log(HttpServletRequest request, RpcMessage message, boolean isRequest) {
    }

    static void log(SocketConnection conn, RpcSocketPDU pdu, boolean isRequest) {
    }

    static String calcAttachment(RpcMessage msg) {
        String attachment = "";
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, byte[]> entry : msg.getAttachments().entrySet()) {
            if (entry.getKey().compareTo("monitor.rpc.message") == 0) continue;
            attachment = "<attachment name=\"" + entry.getKey() + "\" size =" + entry.getValue().length + " />" + newline;
            result.append(attachment);
        }
        return result.toString();
    }

    static /* synthetic */ SimpleDateFormat access$000() {
        return formater;
    }

    static {
        isRealtime = false;
        instance = new RpcTrace();
        newline = "\n";
        formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        pool = null;
    }

    class RpcPusher
    implements Callable {
        HttpServletRequest request = null;
        RpcMessage message;
        String path = "";
        SocketConnection connection = null;
        String time = RpcTrace.access$000().format(new Date());

        RpcPusher(HttpServletRequest req, RpcMessage msg, boolean bool) {
            this.request = req;
            this.message = msg;
        }

        RpcPusher(SocketConnection conn, RpcSocketPDU pdu, boolean bool) {
            this.connection = conn;
            this.message = pdu.getMessage();
            this.path = pdu.getPath();
        }

        public Object call() {
            try {
                this.wrapMessage(this.message);
                RpcEvent event = new RpcEvent(this.message);
                event.setType("imap.trace.rpc");
                RpcServerPush.push(monitorID, event);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            return null;
        }

        void wrapMessage(RpcMessage message) {
            DataTable info = message.getTable("_trace");
            if (info == null) {
                info = new DataTable("_trace");
            }
            info.addParameter("date", this.time);
            info.addParameter("type", message.getType());
            if (this.request == null) {
                info.addParameter("target", RpcTrace.getURI(this.connection) + this.path);
                info.addParameter("source", RpcTrace.getRemoteSocketAddress(this.connection));
            } else {
                info.addParameter("target", this.request.getRequestURL().toString());
                info.addParameter("source", this.request.getRemoteHost() + ':' + this.request.getRemotePort());
            }
            message.addTable(info);
        }
    }
}

