/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcSocketPDU
implements ISocketPDU {
    private static Log log = LogFactory.getLog(RpcSocketPDU.class);
    public static final byte REQUEST = 1;
    public static final byte RESPONSE = 2;
    public static final byte ONEWAY = 3;
    public static final byte EVENT = 4;
    public static final byte HEARTBEAT = 5;
    public static final byte CANCEL = 6;
    public static final byte MRBREADER = 7;
    public static final byte COMPRESS = 8;
    public static final String COMPRESSED_BYTES = "COMPRESSEDBYTES";
    private byte type;
    private String path;
    private RpcMessage message;
    private Object attachment;
    private Long cancelTime = Long.MAX_VALUE;

    RpcSocketPDU() {
        this.message = new RpcMessage("request");
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.cancelTime;
    }

    public void setTimeout(Long timeout) {
        if (this.message != null) {
            this.message.addParameter("dsf_rpc_timeout", timeout);
        }
    }

    public void setCancelTime() {
        if (this.message != null && this.message.hasParameter("dsf_rpc_timeout")) {
            long timeout = this.message.getLong("dsf_rpc_timeout");
            this.cancelTime = System.currentTimeMillis() + timeout;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("=========timeout=%s, current=%s, cancelTime=%s", timeout / 1000L, (this.cancelTime - timeout) / 1000L, this.cancelTime / 1000L));
            }
            this.message.getParameterMap().remove("dsf_rpc_timeout");
        }
    }

    public void setCancelTime(long cancelTime) {
        this.cancelTime = cancelTime;
    }

    public long getCancelTime() {
        return this.cancelTime;
    }

    public RpcSocketPDU(byte type, String path, RpcMessage message) {
        this.type = type;
        this.path = path;
        this.message = message;
    }

    public RpcSocketPDU(byte type) {
        this.type = type;
    }

    final void setType(byte type) {
        this.type = type;
    }

    final void setPath(String path) {
        this.path = path;
    }

    public final void setMessage(RpcMessage message) {
        this.message = message;
    }

    public final byte getType() {
        return this.type;
    }

    public final String getPath() {
        return this.path;
    }

    public final RpcMessage getMessage() {
        return this.message;
    }

    public void attach(Object obj) {
        this.attachment = obj;
    }

    Object getAttachment() {
        return this.attachment;
    }

    public String toString() {
        return "type=" + this.type + ", path=" + this.path + ", msg=" + this.message;
    }

    @Override
    public byte supportConcurrent() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.message.getMessageId();
    }
}

