/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcInvoker;
import com.swimap.base.rpc.RpcPendingRequest;
import com.swimap.base.rpc.RpcServerPushDispatcher;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.RpcSocketProtocolTCP;
import com.swimap.base.rpc.RpcSocketProtocolTCPSsl;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.base.rpc.nio.SocketClientConnector;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.RpcErrorTimeout;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcSocketClient
extends SocketClient {
    private static Log log = LogFactory.getLog(RpcSocketClient.class);
    private static int reconnectCount = Integer.MAX_VALUE;
    private static long clientID = 0L;
    private static Timer timer = new Timer();
    private static final int AUTO_INTERVAL = 60000;

    public RpcSocketClient() {
        RpcServerPush.getReceiver();
        timer.schedule((TimerTask)new PipeCleaner(), 60000L, 60000L);
    }

    public static void setReconnectCount(int count) {
        reconnectCount = count;
    }

    public static void setClientID(long id) {
        clientID = id;
    }

    public static long getClientID() {
        if (clientID == 0L) {
            clientID = RpcSocketClient.createClientID();
        }
        return clientID;
    }

    static long createClientID() {
        long clientID;
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String jvm = bean.getName();
        try {
            String pid = jvm.substring(0, jvm.indexOf("@"));
            clientID = Long.parseLong(RpcUtil.convertIp2Num(4) + pid);
            log.warn((Object)("createClientID:" + clientID));
        }
        catch (Exception e) {
            clientID = Long.parseLong(RpcUtil.convertIp2Num(3) + RpcUtil.getSystemTime(), 2);
        }
        return clientID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcMessage sendRequest(URI uri, RpcMessage message, long timeout, SSLContext context) throws Exception {
        RpcSocketProtocolTCP socketProtocol = null;
        SocketConnection conn = null;
        URI tempUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null);
        if (context != null) {
            conn = this.getConnection(context, new RpcSocketProtocolTCPSsl(), tempUri, timeout, reconnectCount);
            socketProtocol = (RpcSocketProtocolTCPSsl)conn.getConnector().getProtocol();
        } else {
            conn = this.getConnection(context, new RpcSocketProtocolTCP(), tempUri, timeout, reconnectCount);
            socketProtocol = (RpcSocketProtocolTCP)conn.getConnector().getProtocol();
        }
        int mid = this.newMID();
        message.setMessageId(mid);
        RpcPendingRequest pending = new RpcPendingRequest(mid, socketProtocol.getRequsetPendings());
        try {
            RpcSocketPDU pdu = new RpcSocketPDU(1, uri.getPath(), message);
            pdu.attach(pending);
            pdu.setTimeout(timeout);
            conn.writePDU(pdu);
            RpcMessage rsp = null;
            try {
                rsp = pending.getResponse(timeout);
            }
            catch (RpcErrorTimeout error) {
                RpcMessage cancel = new RpcMessage("request");
                cancel.setMessageId(pdu.getMessage().getMessageId());
                pdu = new RpcSocketPDU(6, "", cancel);
                conn.writePDU(pdu);
                throw error;
            }
            RpcMessage rpcMessage = rsp;
            return rpcMessage;
        }
        finally {
            pending.close();
        }
    }

    public void sendOneway(URI uri, RpcMessage message, long timeout, SSLContext context) throws Exception {
        SocketConnection conn = null;
        URI tempUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null);
        conn = context != null ? this.getConnection(context, new RpcSocketProtocolTCPSsl(), tempUri, timeout, reconnectCount) : this.getConnection(context, new RpcSocketProtocolTCP(), tempUri, timeout, reconnectCount);
        conn.writePDU(new RpcSocketPDU(3, uri.getPath(), message));
    }

    public static void setThreadPool(ExecutorService executor) {
        if (threadPool == null) {
            threadPool = executor;
            RpcServerPushDispatcher.getInstance().setServerPushThreadPool(executor);
            RpcInvoker.instance.setThreadPool(executor);
        }
    }

    public static void setSingleThread(ExecutorService executor) {
        singleThread = executor;
    }

    class PipeCleaner
    extends TimerTask {
        private static final long TIME_LIMITED = 600000L;
        private long interval = 0L;

        PipeCleaner() {
        }

        @Override
        public void run() {
            try {
                for (SocketClientConnector connector : RpcSocketClient.this.getClientConnectors()) {
                    this.doTask(connector);
                }
            }
            catch (Exception e) {
                log.warn((Object)"");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doTask(SocketClientConnector connector) {
            RpcMessage message = new RpcMessage("request");
            if (!(connector.getProtocol() instanceof RpcSocketProtocolTCP)) {
                return;
            }
            SocketConnection conn = connector.getConnection();
            if (conn == null) {
                return;
            }
            this.interval = System.currentTimeMillis() - conn.getLastReadTime();
            if (conn.isConnected() && this.interval > 600000L) {
                try {
                    conn.close(new IOException());
                }
                catch (Exception e) {
                    log.warn((Object)"cloes pipeline connection failed.", (Throwable)e);
                }
            } else if (conn.isConnected()) {
                int mid = RpcSocketClient.this.newMID();
                message.setMessageId(mid);
                RpcPendingRequest pending = new RpcPendingRequest(mid, ((RpcSocketProtocolTCP)connector.getProtocol()).getRequsetPendings());
                try {
                    URI uri = new URI(connector.getKey());
                    RpcSocketPDU pdu = new RpcSocketPDU(5, uri.getPath(), message);
                    pdu.attach(pending);
                    conn.writePDU(pdu);
                    pending.getResponse(10000L);
                }
                catch (Exception e) {
                    log.warn((Object)("send heart beat to " + conn.getRemoteAddress() + ":" + conn.getRemotePort() + "(" + conn.getClientID() + ") " + "failed."), (Throwable)e);
                }
                finally {
                    pending.close();
                }
            }
        }
    }
}

