/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import java.util.HashMap;
import java.util.Map;

public class RpcSessionClientIDPairs {
    static final Map<Integer, Long> pairs = new HashMap<Integer, Long>();
    static final Map<Long, Integer> client2SessionMap = new HashMap<Long, Integer>();

    public static synchronized void addPair(Integer sessionID, Long clientID) {
        Integer oldSessionId = client2SessionMap.put(clientID, sessionID);
        if (null != oldSessionId) {
            pairs.remove(oldSessionId);
        }
        pairs.put(sessionID, clientID);
    }

    public static synchronized Long removePair(Integer sessionID) {
        Long clientId = pairs.remove(sessionID);
        if (clientId != null) {
            client2SessionMap.remove(clientId);
        }
        return clientId;
    }

    public static synchronized void clear() {
        pairs.clear();
        client2SessionMap.clear();
    }

    public static synchronized Long getClientID(Integer sessionID) {
        return pairs.get(sessionID);
    }

    public static synchronized boolean hasSession(Integer sessionID) {
        return pairs.containsKey(sessionID);
    }

    public static synchronized boolean hasClientID(Long clientID) {
        return client2SessionMap.containsKey(clientID);
    }
}

