/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.BinHelper;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcRegisterItem;
import com.swimap.base.rpc.RpcServer;
import com.swimap.base.rpc.RpcTrace;
import com.swimap.base.rpc.XmlHelper;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorMethodNotFound;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RpcServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(RpcServlet.class);
    private static final String ENCODING = "UTF-8";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_GET = "GET";
    public static final String XML_CONTENT = "text/xml";
    public static final String FORM_CONTENT = "application/x-www-form-urlencoded";
    public static final String BIN_CONTENT = "application/imaprpc";

    RpcServlet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (!method.equals(HTTP_GET) && !method.equals(HTTP_POST)) {
            response.sendError(405, "only support GET or POST method");
            log.warn((Object)("not a GET/POST request: " + method));
            return;
        }
        RpcRequestHandler handler = new RpcRequestHandler(request, response);
        try {
            handler.handleRequest();
        }
        finally {
            if (log.isDebugEnabled()) {
                this.sendTrace(request, handler, false);
            }
        }
    }

    protected void sendTrace(HttpServletRequest request, RpcRequestHandler handler, boolean isRequest) {
        RpcMessage trace = null;
        if (request.getPathInfo().startsWith("/event/") || request.getPathInfo().startsWith("/naming/")) {
            return;
        }
        if (isRequest) {
            trace = handler.req.clone();
        } else if (handler.rsp != null) {
            trace = handler.rsp.clone();
        }
        if (RpcTrace.isRealtime) {
            RpcTrace.getInstance().push(request, trace, isRequest);
        } else {
            RpcTrace.log(request, trace, isRequest);
        }
    }

    class RpcRequestHandler {
        private ContentType contentType;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private String path;
        RpcMessage req = null;
        RpcMessage rsp = null;

        RpcRequestHandler(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        boolean getContentType() throws IOException {
            if (this.request.getMethod().equals(RpcServlet.HTTP_GET)) {
                this.contentType = ContentType.form;
                return true;
            }
            String requestType = this.request.getContentType();
            if (requestType == null) {
                this.response.sendError(400, "content type required");
                log.warn((Object)"content type required");
                return false;
            }
            if (RpcServlet.BIN_CONTENT.equals(requestType)) {
                this.contentType = ContentType.bin;
            } else if (requestType.startsWith(RpcServlet.FORM_CONTENT)) {
                this.contentType = ContentType.form;
            } else if (requestType.startsWith(RpcServlet.XML_CONTENT)) {
                this.contentType = ContentType.xml;
            } else {
                this.response.sendError(400, "not a valid content type : " + requestType);
                log.warn((Object)("not a valid content type : " + requestType));
                return false;
            }
            return true;
        }

        void handleRequest() throws ServletException, IOException {
            this.path = this.request.getPathInfo();
            if (this.path == null) {
                this.response.sendError(404, "request with null path");
                log.warn((Object)"request with null path");
                return;
            }
            if (!this.getContentType()) {
                return;
            }
            if (this.contentType == ContentType.bin) {
                this.response.setContentType(RpcServlet.BIN_CONTENT);
            } else {
                this.response.setContentType(RpcServlet.XML_CONTENT);
                this.response.setHeader("cache-control", "no-cache");
            }
            this.response.setStatus(200);
            this.response.setCharacterEncoding(RpcServlet.ENCODING);
            RpcMessage message = null;
            try {
                RpcRegisterItem call;
                message = this.getMessage();
                if (log.isDebugEnabled()) {
                    this.req = message;
                    RpcServlet.this.sendTrace(this.request, this, true);
                }
                if ((call = RpcRegister.instance().getItem(this.path, message.getParameterNames())) == null) {
                    this.response.setStatus(400);
                    this.responseException(message, new RpcErrorMethodNotFound(this.path));
                    if (log.isInfoEnabled()) {
                        StringBuilder sb = new StringBuilder(this.path + '?');
                        Set<String> names = message.getParameterNames();
                        for (String name : names) {
                            sb.append(name);
                            sb.append(",");
                        }
                        log.warn((Object)("rcp method not found: " + sb.toString()));
                    }
                    return;
                }
                if (call.notExported() && RpcServer.isRestricted(this.request)) {
                    this.response.setStatus(404);
                    this.responseException(message, new RpcErrorSecurity("RPC method not exported"));
                    log.warn((Object)("Method not exported: " + this.path));
                    return;
                }
                this.executeCall(call, message);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                if (cause instanceof AppError || cause instanceof RpcError) {
                    this.responseException(message, cause);
                } else if (cause != null) {
                    this.responseException(message, new RpcError(cause));
                } else {
                    this.responseException(message, new RpcError(ite));
                }
            }
            catch (RpcError e) {
                this.responseException(message, e);
            }
            catch (Exception e) {
                this.responseException(message, new RpcError(e));
            }
        }

        protected RpcMessage getMessage() throws Exception {
            if (this.contentType == ContentType.bin) {
                return BinHelper.parseMessage((InputStream)this.request.getInputStream());
            }
            if (this.contentType == ContentType.xml) {
                return XmlHelper.parseMessage((InputStream)this.request.getInputStream());
            }
            RpcMessage message = new RpcMessage("request");
            message.setParameters(this.request.getParameterMap());
            return message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeCall(RpcRegisterItem call, RpcMessage message) throws Exception {
            RpcContext rpcContext = new RpcContext(call.getMethod(), this.request, this.response, message);
            try {
                if (RpcServer.isRestricted(this.request) && RpcRegister.instance().hasSecurityChecker()) {
                    RpcRegister.instance().getSecurityChecker().checkSecurity(rpcContext);
                }
                call.invoke(message.getParameterMap(), rpcContext);
                this.writeResponse(rpcContext.getResponseMessage(), message.getXSLT());
            }
            finally {
                rpcContext.close();
            }
        }

        protected void responseException(RpcMessage message, Throwable e) {
            if (e instanceof AppError) {
                log.warn((Object)"AppError", e);
            } else if (e instanceof RpcErrorMethodNotFound && e.getMessage().startsWith("/balance/getFreeDS")) {
                log.warn((Object)"RpcErrorMethodNotFound : /balance/getFreeDS");
            } else {
                log.warn((Object)"Call RPC method failed", e);
            }
            RpcMessage exception = RpcMessage.getErrorMessage(e);
            if (message != null && message.hasMessageId()) {
                exception.setMessageId(message.getMessageId());
            }
            this.writeResponse(exception, null);
        }

        protected void writeResponse(RpcMessage message, String xslt) {
            this.rsp = message;
            try {
                if (this.contentType == ContentType.bin) {
                    BinHelper.writeMessage((OutputStream)this.response.getOutputStream(), message);
                } else {
                    XmlHelper.writeMessage((OutputStream)this.response.getOutputStream(), message, xslt);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Write response failed", (Throwable)ex);
            }
        }
    }

    static enum ContentType {
        bin,
        xml,
        form;

    }
}

