/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.PrintEventTypes;
import com.swimap.base.rpc.RpcServerPushDispatcher;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcServerPushHandlerProxy
implements Runnable {
    private static Log log = LogFactory.getLog(RpcServerPushHandlerProxy.class);
    private String[] eventType;
    private RpcServerPushDispatcher dispatcher;
    private RpcServerPushHandler serverPushHandler;
    private static final int EVENT_STACK_NUMBER = 20;
    private static final int EVENT_NUMBER_INTERVAL = 10;
    private int intervalNumberCount = 10;
    private boolean traceFlag = true;
    private LinkedList<RpcEvent> eventlist = new LinkedList();
    private boolean isRunning = false;

    public RpcServerPushHandlerProxy(String eventType, RpcServerPushHandler serverPushHandler) {
        this.eventType = new String[1];
        this.eventType[0] = eventType;
        this.serverPushHandler = serverPushHandler;
        this.dispatcher = RpcServerPushDispatcher.getInstance();
    }

    public RpcServerPushHandlerProxy(String[] eventType, RpcServerPushHandler serverPushHandler) {
        this.eventType = eventType;
        this.serverPushHandler = serverPushHandler;
        this.dispatcher = RpcServerPushDispatcher.getInstance();
    }

    public RpcServerPushHandler getRpcServerPushHandler() {
        return this.serverPushHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(RpcEvent event) {
        LinkedList<RpcEvent> linkedList = this.eventlist;
        synchronized (linkedList) {
            if (!this.isRunning && this.eventlist.isEmpty()) {
                this.eventlist.offer(event);
                this.dispatcher.registerProxy(this);
            } else {
                this.eventlist.offer(event);
                int size = 0;
                size = this.eventlist.size();
                if (size > 20) {
                    if (this.traceFlag) {
                        log.warn((Object)("Push proxy | Type = " + Arrays.toString(this.eventType) + " | " + this.serverPushHandler.getClass().getSimpleName() + " | block number " + size));
                        this.traceFlag = false;
                    } else {
                        ++this.intervalNumberCount;
                        if (this.intervalNumberCount > 10) {
                            this.intervalNumberCount = 0;
                            this.traceFlag = true;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventListSize() {
        LinkedList<RpcEvent> linkedList = this.eventlist;
        synchronized (linkedList) {
            return this.eventlist.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        while (true) {
            RpcEvent event;
            LinkedList<RpcEvent> linkedList = this.eventlist;
            synchronized (linkedList) {
                event = this.eventlist.poll();
            }
            this.handleServerPush(event);
            linkedList = this.eventlist;
            synchronized (linkedList) {
                if (this.eventlist.isEmpty()) {
                    this.isRunning = false;
                    break;
                }
            }
        }
    }

    private void handleServerPush(RpcEvent event) {
        if (event != null) {
            try {
                String eventType = event.getType();
                PrintEventTypes.getInstance().record(eventType);
                this.serverPushHandler.handleServerPush(event);
            }
            catch (Exception e) {
                log.debug((Object)"handle event failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<RpcEvent> linkedList = this.eventlist;
        synchronized (linkedList) {
            this.eventlist.clear();
        }
    }
}

