/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcServerPushHandlerProxy;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcServerPushDispatcher
implements Runnable {
    private static Log log = LogFactory.getLog(RpcServerPushDispatcher.class);
    private final Object mutex = new Object();
    private Boolean running = false;
    private Thread selectThread;
    private ExecutorService serverPushThreadPool;
    private LinkedBlockingQueue<RpcServerPushHandlerProxy> handlerProxys = new LinkedBlockingQueue();
    private static RpcServerPushDispatcher instance;

    public static RpcServerPushDispatcher getInstance() {
        if (instance == null) {
            instance = new RpcServerPushDispatcher();
        }
        return instance;
    }

    private RpcServerPushDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mutex;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running.booleanValue()) {
                return;
            }
            this.running = true;
            if (this.serverPushThreadPool == null) {
                this.serverPushThreadPool = ThreadPoolManager.getInstance().getServerPushThreadPool();
            }
            this.selectThread = new Thread((Runnable)this, "rpc_serverpush_dispatcher");
            this.selectThread.start();
        }
    }

    public void setServerPushThreadPool(ExecutorService serverPushThreadPool) {
        this.serverPushThreadPool = serverPushThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.running = false;
        }
        if (this.serverPushThreadPool != null) {
            this.serverPushThreadPool.shutdown();
            this.serverPushThreadPool = null;
        }
    }

    public void registerProxy(RpcServerPushHandlerProxy proxy) {
        try {
            this.handlerProxys.put(proxy);
        }
        catch (InterruptedException e) {
            log.error((Object)"register serverpush proxy failed");
        }
    }

    @Override
    public void run() {
        while (this.running.booleanValue()) {
            try {
                RpcServerPushHandlerProxy proxy = this.handlerProxys.take();
                this.serverPushThreadPool.execute(proxy);
            }
            catch (Exception e) {
                log.error((Object)"serverpush handler dispatcher error", (Throwable)e);
            }
        }
    }
}

