/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.Framework;
import com.swimap.base.rpc.CustomErrorPageErrorHandler;
import com.swimap.base.rpc.DSFMRBSericeHandler;
import com.swimap.base.rpc.DefaultRpcServlet;
import com.swimap.base.rpc.Http2HttpsFilter;
import com.swimap.base.rpc.RpcConnectorManager;
import com.swimap.base.rpc.RpcEMHandler;
import com.swimap.base.rpc.RpcEventReceiver;
import com.swimap.base.rpc.RpcEventSender;
import com.swimap.base.rpc.RpcInvoker;
import com.swimap.base.rpc.RpcNamingCache;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcServlet;
import com.swimap.base.rpc.em.EMRequest;
import com.swimap.base.rpc.mrb.MRBServiceManager;
import com.swimap.base.rpc.msg.MSG;
import com.swimap.base.rpc.nio.IConnector;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketServer;
import com.swimap.base.rpc.proxy.Proxy;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.mrb.IMRBHandler;
import com.swimap.external.dsf.base.rpc.mrb.MRB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RpcServer {
    private static Log log = LogFactory.getLog(RpcServer.class);
    private static final String PROPERTY_WEBROOT = "imap.rpc.webroot";
    private static final String PROPERTY_WEBRES = "imap.rpc.webres";
    private static final String PROPERTY_DIR_ALLOWED = "imap.rpc.web.dirAllowed";
    private static final char DEFAULT_LOCAL_PID = '\u270f';
    private RpcConnectorManager connectorManager;
    private Server webServer;
    private File webServerTempDir;
    private ContextHandlerCollection contexts;
    private final Map<String, ServletContextHandler> contextMap = new ConcurrentHashMap<String, ServletContextHandler>();
    private SocketServer socketServer;
    private String webroot = System.getProperty("imap.rpc.webroot");
    private static RpcServer instance;
    private List<Integer> ports = null;

    protected RpcServer() {
        instance = this;
    }

    public static synchronized RpcServer getInstance() {
        if (instance == null) {
            instance = new RpcServer();
        }
        return instance;
    }

    public void start() throws Exception {
        this.doStart();
        this.finishStart();
    }

    public void doStart() throws Exception {
        this.connectorManager = new RpcConnectorManager();
        if (this.connectorManager.hasWebConnector()) {
            this.initWebServer();
        }
        if (this.connectorManager.hasSocketConnector()) {
            this.initSocketServer();
        }
        this.ports = this.connectorManager.getPortList();
        this.initAsPort();
        RpcRegister.add(RpcNamingCache.instance);
        RpcNaming.instance().setLocalURL(this.connectorManager.getLocalURL());
        RpcRegister.add(RpcEventReceiver.instance);
        RpcRegister.add(RpcEventSender.instance);
        this.initApplicationServer();
        if (MRB.getDefault() != null) {
            int procid = this.getProcID();
            DSFMRBSericeHandler mrbHandler = new DSFMRBSericeHandler();
            try {
                MRBServiceManager.instance().register(procid, (IMRBHandler)mrbHandler);
            }
            catch (Exception e) {
                FrameInformationManager.getInstance().record("Dsf mrb register", String.format("Checking register dsf mrbHandler(%s)", System.getProperty("imap.rpc.mdp")), false);
                throw e;
            }
        }
    }

    void initAsPort() throws Exception {
        URI uri;
        int mdpport = -1;
        int emport = -1;
        String url = System.getProperty("imap.rpc.mdp");
        if (url != null) {
            try {
                mdpport = Integer.valueOf(System.getProperty("mdpport"));
            }
            catch (NumberFormatException e) {
                mdpport = -1;
            }
            if (mdpport != -1) {
                uri = new URI(url);
                url = uri.getScheme() + "://" + uri.getHost() + ':' + mdpport;
                System.setProperty("imap.rpc.mdp", url);
            }
        }
        if ((url = System.getProperty("imap.rpc.em")) != null) {
            try {
                emport = Integer.valueOf(System.getProperty("emport"));
            }
            catch (NumberFormatException e) {
                emport = -1;
            }
            if (emport != -1) {
                uri = new URI(url);
                url = uri.getScheme() + "://" + uri.getHost() + ':' + emport;
                System.setProperty("imap.rpc.em", url);
            }
        }
    }

    void initApplicationServer() throws Exception {
        String url = System.getProperty("imap.rpc.mdp");
        if (url != null) {
            if (url.startsWith("mdps")) {
                MRB.setDefault(MRB.createInstance(url, Framework.getSSLcontext()));
                MSG.setDefault(MSG.createInstance(url, Framework.getSSLcontext()));
            } else if (url.startsWith("mdp")) {
                MRB.setDefault(MRB.createInstance(url));
                MSG.setDefault(MSG.createInstance(url));
            }
        }
        if ((url = System.getProperty("imap.rpc.em")) != null) {
            if (url.startsWith("ems")) {
                EMRequest.setDefault(EMRequest.create(url, Framework.getSSLcontext(), RpcEMHandler.instance));
            } else if (url.startsWith("em")) {
                EMRequest.setDefault(EMRequest.create(url, RpcEMHandler.instance));
            }
        }
    }

    private int getProcID() {
        try {
            String procID = System.getProperty("procID");
            return Integer.parseInt(procID);
        }
        catch (Exception e) {
            return 9999;
        }
    }

    public void addServlet(String path, String pattern, Servlet servlet) {
        ServletContextHandler context = this.getContext(path);
        context.addServlet(new ServletHolder(servlet), pattern);
        context.addFilter(this.createHttp2HttpsFilter(path), "/*", 0);
    }

    public static boolean redirect2HTTPs(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean isSecure = request.isSecure();
            if (!isSecure) {
                String httpsPath;
                Connector[] connectors = RpcServer.getInstance().getWebServer().getConnectors();
                String httpPort = ":" + String.valueOf(request.getServerPort());
                String httpPath = request.getRequestURL().toString();
                String httpsPort = new String(httpPort);
                for (int i = 0; i < connectors.length; ++i) {
                    if (!connectors[i].isRunning() || !connectors[i].isConfidential(null)) continue;
                    httpsPort = ":" + String.valueOf(connectors[i].getPort());
                    break;
                }
                if (request.getServerPort() == 80 && httpPath.indexOf(httpPort) == -1) {
                    int dir = httpPath.indexOf("/", 7);
                    httpsPath = httpPath.substring(0, dir) + httpsPort + httpPath.substring(dir);
                } else {
                    httpsPath = httpPath.replace(httpPort, httpsPort);
                }
                httpsPath = httpsPath.replace("http", "https");
                response.sendRedirect(httpsPath);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebApp(String path, String webAppLocation) {
        File webAppDir = new File(webAppLocation);
        if (!webAppDir.isAbsolute()) {
            webAppLocation = new File(Framework.getHomeDir(), webAppLocation).getAbsolutePath();
        }
        WebAppContext context = new WebAppContext(webAppLocation, path);
        context.setHandler((Handler)new SessionHandler());
        this.getContexts().addHandler((Handler)context);
        File temp = this.createNewWebTempDir();
        if (temp != null) {
            context.setTempDirectory(temp);
        }
        Map<String, ServletContextHandler> map = this.contextMap;
        synchronized (map) {
            this.contextMap.put(path, (ServletContextHandler)context);
        }
        context.addFilter(this.createHttp2HttpsFilter(path), "/*", 0);
        if (this.getContexts().isRunning()) {
            try {
                context.start();
            }
            catch (Exception e) {
                log.error((Object)("Start WebAppContext failed: " + path), (Throwable)e);
            }
        }
    }

    private void initWebTempDir() {
        File tmpDir = null;
        try {
            if (Framework.getHomeDir() == null || Framework.getInstanceName() == null) {
                return;
            }
            File file = new File(new File(Framework.getHomeDir(), "var"), Framework.getInstanceName());
            if (file.exists() && file.isDirectory() && file.canWrite()) {
                tmpDir = new File(file, "JettyContext");
                if (tmpDir.exists()) {
                    this.deleteDirectory(tmpDir);
                }
                tmpDir.mkdir();
                tmpDir.deleteOnExit();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed init web temp dir", (Throwable)e);
        }
        this.webServerTempDir = tmpDir;
    }

    private File createNewWebTempDir() {
        File temp = null;
        if (this.webServerTempDir != null) {
            try {
                temp = File.createTempFile("content", "", this.webServerTempDir);
                if (temp.exists()) {
                    temp.delete();
                }
                temp.mkdir();
                temp.deleteOnExit();
            }
            catch (IOException e) {
                log.error((Object)"Failed create new temp dir", (Throwable)e);
            }
        }
        return temp;
    }

    private void deleteDirectory(File path) {
        if (path != null && path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
            path.delete();
        }
    }

    public void addProxy(Proxy proxy) {
        if (proxy != null) {
            this.addServlet(proxy.getPath(), "/*", proxy.getServlet());
        }
    }

    public void removeProxy(Proxy proxy) {
        if (proxy != null) {
            this.removeContext(proxy.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(String path) {
        ServletContextHandler context = null;
        Map<String, ServletContextHandler> map = this.contextMap;
        synchronized (map) {
            context = this.contextMap.remove(path);
        }
        if (context != null) {
            this.getContexts().removeHandler((Handler)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletContextHandler getContext(String path) {
        Map<String, ServletContextHandler> map = this.contextMap;
        synchronized (map) {
            ServletContextHandler context = this.contextMap.get(path);
            if (context == null) {
                context = new ServletContextHandler();
                context.setContextPath(path);
                context.setHandler((Handler)new SessionHandler());
                context.setErrorHandler((ErrorHandler)new CustomErrorPageErrorHandler());
                this.getContexts().addHandler((Handler)context);
                if (this.getContexts().isRunning()) {
                    try {
                        context.start();
                    }
                    catch (Exception e) {
                        log.error((Object)("Start web context failed: " + path), (Throwable)e);
                    }
                }
                this.contextMap.put(path, context);
            }
            return context;
        }
    }

    public Map<String, ServletContextHandler> getContext() {
        return this.contextMap;
    }

    private synchronized ContextHandlerCollection getContexts() {
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
        }
        return this.contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWebServer() throws Exception {
        this.initWebTempDir();
        this.webServer = new Server();
        this.webServer.setSendServerVersion(false);
        QueuedThreadPool pool = new QueuedThreadPool();
        pool.setMinThreads(4);
        pool.setMaxThreads(100);
        this.webServer.setThreadPool((ThreadPool)pool);
        this.addServlet("/api", "/*", (Servlet)new RpcServlet());
        Collection<Proxy> proxies = Proxy.loadProxies();
        for (Proxy proxy : proxies) {
            this.addProxy(proxy);
        }
        this.loadWebApps();
        if (this.webroot != null) {
            ServletContextHandler rootContext = new ServletContextHandler((HandlerContainer)this.getContexts(), "/", 1);
            HashSessionManager sessionManager = (HashSessionManager)rootContext.getSessionHandler().getSessionManager();
            sessionManager.setHttpOnly(true);
            sessionManager.setSecureCookies(true);
            File rootDir = new File(this.webroot);
            if (!rootDir.isAbsolute()) {
                rootDir = new File(Framework.getHomeDir(), rootDir.getPath());
            }
            String resDir = Framework.getHomeDir() + '/' + System.getProperty(PROPERTY_WEBRES, "res");
            ServletHolder defaultServlet = new ServletHolder((Servlet)new DefaultRpcServlet());
            defaultServlet.setInitParameter("dirAllowed", System.getProperty(PROPERTY_DIR_ALLOWED, "false"));
            String rootPath = rootDir.getAbsolutePath();
            rootContext.setResourceBase(rootPath);
            rootContext.addServlet(defaultServlet, "/*");
            rootContext.setErrorHandler((ErrorHandler)new CustomErrorPageErrorHandler());
            log.warn((Object)("Start HTTP file service on " + rootPath));
            ServletContextHandler resCtx = new ServletContextHandler((HandlerContainer)this.getContexts(), "/res");
            resCtx.setResourceBase(resDir);
            resCtx.addServlet(DefaultRpcServlet.class, "/*");
            resCtx.setErrorHandler((ErrorHandler)new CustomErrorPageErrorHandler());
            Map<String, ServletContextHandler> map = this.contextMap;
            synchronized (map) {
                this.contextMap.put("/", rootContext);
                this.contextMap.put("/res", resCtx);
            }
            rootContext.addFilter(this.createHttp2HttpsFilter(rootPath), "/*", 0);
            resCtx.addFilter(this.createHttp2HttpsFilter(resDir), "/*", 0);
        }
        this.webServer.setHandler((Handler)this.getContexts());
        this.webServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilterHolder createHttp2HttpsFilter(String path) {
        Http2HttpsFilter http2https = new Http2HttpsFilter();
        HashSet<String> filters = new HashSet<String>();
        File configFile = new File(path + File.separator + "http2https.filter");
        log.warn((Object)("path:" + configFile.getAbsolutePath()));
        if (!configFile.exists()) {
            return new FilterHolder((Filter)http2https);
        }
        BufferedReader bf = null;
        try {
            String item;
            bf = new BufferedReader(new FileReader(configFile));
            while ((item = bf.readLine()) != null) {
                if (!item.startsWith("/")) continue;
                filters.add(item);
            }
            http2https = new Http2HttpsFilter();
            http2https.addRedirectURLs(filters);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to configure http2https filter.", (Throwable)e);
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the configure file.", (Throwable)e);
                }
            }
        }
        return new FilterHolder((Filter)http2https);
    }

    private void initSocketServer() throws Exception {
        this.socketServer = new SocketServer();
        this.socketServer.start();
        this.socketServer.setSocketClientServer();
    }

    void finishStart() throws Exception {
        if (this.webServer != null) {
            for (Connector connector : this.connectorManager.getWebConnectors()) {
                this.webServer.addConnector(connector);
                connector.start();
                log.warn((Object)("connector.getLocalPort():" + connector.getLocalPort()));
                if (connector.getLocalPort() != -1) continue;
                log.error((Object)"Port not listening, restart connector.");
                connector.start();
            }
        }
        if (this.socketServer != null) {
            for (SocketConnector socketConnector : this.connectorManager.getSocketConnectors()) {
                this.socketServer.addConnector(socketConnector);
            }
        }
    }

    public static void addFilter(String context, String pathSpec, Filter filter) {
        ServletContextHandler ctx = RpcServer.getInstance().getContext(context);
        FilterHolder holder = new FilterHolder(filter);
        ctx.addFilter(holder, pathSpec, 0);
    }

    public void stop() throws Exception {
        this.doStop();
    }

    public void doStop() throws Exception {
        RpcInvoker.instance.close();
        RpcRegister.remove(RpcEventReceiver.instance);
        RpcRegister.remove(RpcEventSender.instance);
        RpcRegister.remove(RpcNamingCache.instance);
        this.revokeApplicationServer();
        if (this.webServer != null) {
            this.webServer.stop();
            this.webServer = null;
        }
        if (this.socketServer != null) {
            this.socketServer.stop();
            this.socketServer = null;
        }
        this.connectorManager = null;
        log.warn((Object)"RPC Server stopped.");
    }

    void revokeApplicationServer() {
        MRB.setDefault(null);
        EMRequest.setDefault(null);
    }

    public boolean isStarted() {
        boolean webServerStarted = this.webServer == null || this.webServer.isStarted();
        boolean socketServerStarted = this.socketServer == null || this.socketServer.isRunning();
        return webServerStarted && socketServerStarted;
    }

    public void join() throws Exception {
        if (this.webServer != null) {
            this.webServer.join();
        }
        if (this.socketServer != null) {
            this.socketServer.join();
        }
    }

    Server getWebServer() {
        return this.webServer;
    }

    SocketServer getSocketServer() {
        return this.socketServer;
    }

    public List<Integer> getOpenPorts() {
        return this.ports;
    }

    public static boolean isRestricted(HttpServletRequest request) {
        Request jettyRequest = Request.getRequest((HttpServletRequest)request);
        return RpcServer.isRestricted(jettyRequest.getConnection().getConnector());
    }

    static boolean isRestricted(Connector connector) {
        if (connector instanceof IConnector) {
            return ((IConnector)connector).isRestricted();
        }
        return false;
    }

    protected void loadWebApps() {
        try {
            File file = new File(Framework.getConfigDir(), "webapp.xml");
            if (!file.exists()) {
                return;
            }
            log.warn((Object)"Found webapp.xml, load web applications...");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dom = builder.parse(file);
            if (!"webapps".equals(dom.getDocumentElement().getNodeName())) {
                log.warn((Object)"No <webapps> tag found in webapp.xml.");
                return;
            }
            NodeList nodeList = dom.getElementsByTagName("webapp");
            Node node = null;
            String path = null;
            String location = null;
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                node = nodeList.item(i);
                path = RpcServer.getAttribute(node, "path");
                location = RpcServer.getAttribute(node, "location");
                this.addWebApp(path, location);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Load webapp.xml failed: " + e.getMessage()));
        }
    }

    private static String getAttribute(Node node, String name) throws Exception {
        Node attr = node.getAttributes().getNamedItem(name);
        if (attr == null) {
            throw new Exception("Attribute '" + name + "' not found in '" + node.getNodeName() + "' tag.");
        }
        return attr.getNodeValue();
    }

    public RpcConnectorManager getConnectorManager() {
        return this.connectorManager;
    }
}

