/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;

public class RpcRetryHandler
implements HttpMethodRetryHandler {
    private static final int MAX_RETRY_COUNT = 3;

    public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
        if (method == null) {
            throw new IllegalArgumentException("HTTP method may not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("Exception parameter may not be null");
        }
        if (executionCount > 3) {
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        if (exception instanceof InterruptedIOException) {
            return false;
        }
        if (exception instanceof UnknownHostException) {
            return false;
        }
        if (exception instanceof NoRouteToHostException) {
            return false;
        }
        if (!method.isRequestSent()) {
            return true;
        }
        return exception instanceof SocketException && exception.getMessage().contains("Software caused connection abort");
    }
}

