/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RpcResponseGroup {
    private List<Object> results = new ArrayList<Object>();

    RpcResponseGroup(List<Future<RpcResponse>> futureList) {
        for (Future<RpcResponse> future : futureList) {
            try {
                this.results.add(future.get().getMessage());
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)cause;
                }
                if (cause instanceof AppError) {
                    this.results.add(cause);
                    continue;
                }
                if (cause instanceof RpcError) {
                    this.results.add(cause);
                    continue;
                }
                this.results.add(new RpcError(ee.getCause()));
            }
            catch (Exception e) {
                this.results.add(new RpcError(e));
            }
        }
    }

    public RpcMessage getMessage(int index) throws Exception {
        Object obj = this.results.get(index);
        if (obj instanceof RpcMessage) {
            return (RpcMessage)obj;
        }
        throw (Exception)obj;
    }

    public int size() {
        return this.results.size();
    }
}

