/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcInvoker;
import com.swimap.base.rpc.RpcResponseGroup;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import java.util.ArrayList;
import java.util.List;

public class RpcRequestGroup {
    private List<RpcRequest> requests = new ArrayList<RpcRequest>();

    public RpcRequestGroup(RpcRequest ... requests) {
        for (RpcRequest request : requests) {
            this.requests.add(request);
        }
    }

    RpcRequestGroup(String[] targets, String method, RpcMessage message) {
        for (String target : targets) {
            this.add(target + '/' + method, message);
        }
    }

    public RpcRequestGroup(String[] targets, RpcRequest request) {
        this(targets, request.getURL(), request.getMessage());
    }

    public void add(RpcRequest request) {
        this.requests.add(request);
    }

    public void add(String targetURL, RpcMessage message) {
        RpcRequest request = RpcRequest.create(targetURL);
        request.setMessage(message);
        this.requests.add(request);
    }

    public RpcResponseGroup invoke() throws Exception {
        return RpcInvoker.instance.invokeGroup(this.requests);
    }

    public int size() {
        return this.requests.size();
    }
}

