/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.ValueConvertor;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcParameter;
import java.lang.reflect.Method;
import java.util.Map;

public class RpcRegisterItem {
    private Object object;
    private Method method;
    private String[] argNames;
    private boolean exported;

    RpcRegisterItem(Object object, Method method, String[] argNames) {
        this.object = object;
        this.method = method;
        this.argNames = argNames;
        this.exported = this.getExported(null);
    }

    RpcRegisterItem(Object object, Method method, String[] argNames, Object service) {
        this.object = object;
        this.method = method;
        this.argNames = argNames;
        this.exported = this.getExported(service);
    }

    protected boolean getExported(Object service) {
        Rpc clsAnn;
        Rpc rpc = clsAnn = service == null ? this.object.getClass().getAnnotation(Rpc.class) : service.getClass().getAnnotation(Rpc.class);
        if (clsAnn != null && clsAnn.export()) {
            return true;
        }
        Rpc methodAnn = this.method.getAnnotation(Rpc.class);
        if (methodAnn != null) {
            return methodAnn.export();
        }
        return false;
    }

    boolean isExported() {
        return this.exported;
    }

    boolean notExported() {
        return !this.exported;
    }

    public void invoke(Map<String, RpcParameter> arguments, RpcContext context) throws Exception {
        Class<?>[] types = this.method.getParameterTypes();
        Object[] args = new Object[types.length];
        int i = 0;
        args[i++] = context;
        Object value = null;
        while (i < args.length) {
            value = null;
            if (i - 1 < this.argNames.length) {
                RpcParameter para = arguments.get(this.argNames[i - 1]);
                value = para != null && !(para instanceof DataTable) ? para.getValue() : para;
            } else {
                throw new IllegalArgumentException("@Rpc argument donn't match ");
            }
            if (value == null) {
                throw new IllegalArgumentException(this.argNames[i - 1]);
            }
            args[i] = ValueConvertor.convert(value, types[i]);
            ++i;
        }
        this.method.invoke(this.object, args);
    }

    public Method getMethod() {
        return this.method;
    }
}

