/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.DefaultService;
import com.swimap.base.rpc.IUpgradeHandler;
import com.swimap.base.rpc.RpcRegisterItem;
import com.swimap.base.rpc.RpcSecurityChecker;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcRegister {
    private static final String GET_DELEGATES_METHOD_NAME = "getDelegates";
    private static final String STOP_METHOD_NAME = "stop";
    private static final String START_METHOD_NAME = "start";
    private static final RpcRegister DEFAULT_INSTANCE;
    private static RpcRegister instance;
    private RpcSecurityChecker securityChecker;
    private IUpgradeHandler upgradeHandler;
    private static Log log;
    private Map<String, RpcRegisterItem> registerMap = Collections.synchronizedMap(new HashMap());
    private Map<String, RpcRegisterItem> defaultRegisterMap = Collections.synchronizedMap(new HashMap());
    private Map<Class, Object> serviceInstanceMap = Collections.synchronizedMap(new HashMap());

    public static void setInstance(RpcRegister mock) {
        instance = mock != null ? mock : DEFAULT_INSTANCE;
    }

    public static RpcRegister instance() {
        return instance;
    }

    protected RpcRegister() {
    }

    public static void add(Class cls) throws Exception {
        RpcRegister.instance().addRpc(cls);
    }

    public static void addDefaultService(String defaultPath, Class cls) throws Exception {
        RpcRegister.instance().addDefaultRpc(defaultPath, cls);
    }

    public static void remove(Class cls) throws Exception {
        RpcRegister.instance().removeRpc(cls);
    }

    public static void removeDefault(String defaultPath, Class cls) throws Exception {
        RpcRegister.instance().removeDefaultRpc(defaultPath, cls);
    }

    public static void add(Object service) throws Exception {
        RpcRegister.instance().addRpc(service);
    }

    public static void addDefaultRpc(String defaultPath, Object service) throws Exception {
        RpcRegister.instance().addDefaultRpcObject(defaultPath, service);
    }

    public static void remove(Object service) throws Exception {
        RpcRegister.instance().removeRpc(service);
    }

    public static String getRpcServicePath(Class<?> cls) {
        Rpc ann = cls.getAnnotation(Rpc.class);
        if (ann != null && ann.name().length() > 0) {
            return ann.name().replace('.', '/');
        }
        return cls.getSimpleName();
    }

    static String getRpcMethodPath(Object service, String method) {
        return RpcRegister.getRpcServicePath(service.getClass()) + '/' + method;
    }

    protected static String getMethodRpcName(Method method) {
        Rpc ann = method.getAnnotation(Rpc.class);
        if (ann == null) {
            return "";
        }
        if (ann.name().length() > 0) {
            return ann.name();
        }
        return method.getName();
    }

    static String getPath(Class<?> cls, Method method) {
        return '/' + RpcRegister.getRpcServicePath(cls) + '/' + RpcRegister.getMethodRpcName(method);
    }

    protected String getKey(Class cls, Method method) {
        String path = RpcRegister.getPath(cls, method);
        TreeSet<String> argNames = new TreeSet<String>();
        Rpc ann = method.getAnnotation(Rpc.class);
        if (ann != null && ann.args().length > 0) {
            for (String arg : ann.args()) {
                argNames.add(arg);
            }
        }
        return this.getKey(path, argNames);
    }

    protected String getDelegateKey(Object service, Method method) {
        String path = '/' + RpcRegister.getRpcServicePath(service.getClass()) + '/' + RpcRegister.getMethodRpcName(method);
        TreeSet<String> argNames = new TreeSet<String>();
        Rpc ann = method.getAnnotation(Rpc.class);
        if (ann != null && ann.args().length > 0) {
            for (String arg : ann.args()) {
                argNames.add(arg);
            }
        }
        return this.getKey(path, argNames);
    }

    String getKey(String path, Set<String> argNames) {
        StringBuilder sb = new StringBuilder(path);
        if (argNames != null && argNames.size() > 0) {
            sb.append("?");
            for (String argName : argNames) {
                sb.append(argName);
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public void addRpc(Class cls) throws Exception {
        Object service = cls.newInstance();
        this.addRpc(service);
    }

    protected void addDefaultRpc(String defaultPath, Class cls) throws Exception {
        Object service = cls.newInstance();
        if (!(service instanceof DefaultService)) {
            throw new IllegalArgumentException("input arg must implement DefaultService interface");
        }
        RpcRegister.addDefaultRpc(defaultPath, service);
    }

    protected void addDelegate(Object service, Object delegate) throws Exception {
        Class<?> cls = delegate.getClass();
        Method[] methods = cls.getMethods();
        Rpc ann = null;
        for (Method method : methods) {
            String key;
            ann = method.getAnnotation(Rpc.class);
            if (ann == null || this.registerMap.containsKey(key = this.getDelegateKey(service, method))) continue;
            this.registerMap.put(key, new RpcRegisterItem(delegate, method, ann.args(), service));
        }
    }

    protected void removeDelegate(Object service, Object delegate) throws Exception {
        Method[] methods = delegate.getClass().getMethods();
        Rpc ann = null;
        for (Method method : methods) {
            ann = method.getAnnotation(Rpc.class);
            if (ann == null) continue;
            this.registerMap.remove(this.getDelegateKey(service, method));
        }
    }

    public static List<String> getPathListByService(Class<?> clazz) {
        Method[] methods;
        Vector<String> pathList = new Vector<String>();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(Rpc.class) == null) continue;
            String path = RpcRegister.getPath(clazz, method);
            pathList.add(path);
        }
        return pathList;
    }

    protected void addRpc(Object service) throws Exception {
        Object[] delegates;
        Class<?> cls = service.getClass();
        Method[] methods = cls.getMethods();
        Method getDelegatesMethod = null;
        Rpc ann = null;
        for (Method method : methods) {
            if (getDelegatesMethod == null && method.getName().equals(GET_DELEGATES_METHOD_NAME) && method.getReturnType().equals(Object[].class) && method.getParameterTypes().length == 0) {
                getDelegatesMethod = method;
            }
            if ((ann = method.getAnnotation(Rpc.class)) == null) continue;
            String key = this.getKey(cls, method);
            this.registerMap.put(key, new RpcRegisterItem(service, method, ann.args()));
        }
        if (getDelegatesMethod != null && (delegates = (Object[])getDelegatesMethod.invoke(service, new Object[0])) != null) {
            for (Object delegate : delegates) {
                this.addDelegate(service, delegate);
            }
        }
        this.serviceInstanceMap.put(cls, service);
        this.invokeMethod(service, START_METHOD_NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getChangePath(String defaultPath) {
        String temp = null;
        String patternPath = null;
        if (defaultPath.lastIndexOf(42) < 0) return '/' + defaultPath.replace('.', '/');
        if (defaultPath.lastIndexOf(46) != defaultPath.lastIndexOf(42) - 1) return null;
        temp = defaultPath.substring(0, defaultPath.lastIndexOf(42) - 1);
        return '/' + temp.replace('.', '/');
    }

    protected void addDefaultRpcObject(String defaultPath, Object service) throws Exception {
        String patternPath;
        if (RpcNaming.getNamingServiceURL() != null) {
            RpcNaming.instance().registerDefault(defaultPath, service);
        }
        if ((patternPath = this.getChangePath(defaultPath)) == null) {
            return;
        }
        Class<?> cls = service.getClass();
        Method[] methods = cls.getMethods();
        Rpc ann = null;
        for (Method method : methods) {
            if (!"defautHandler".equalsIgnoreCase(method.getName()) || (ann = method.getAnnotation(Rpc.class)) == null) continue;
            this.defaultRegisterMap.put(patternPath, new RpcRegisterItem(service, method, ann.args()));
        }
        this.serviceInstanceMap.put(cls, service);
        this.invokeMethod(service, START_METHOD_NAME);
    }

    protected void invokeMethod(Object obj, String methodName) throws Exception {
        try {
            long time = 0L;
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            method.invoke(obj, new Object[0]);
            if (log.isDebugEnabled()) {
                String classname = obj.getClass().getName();
                log.debug((Object)(methodName + " service: " + classname + " use" + (System.currentTimeMillis() - time) + " ms."));
            }
        }
        catch (NoSuchMethodException nse) {
        }
        catch (Exception e) {
            String mName = obj.getClass().getName() + '.' + methodName;
            log.error((Object)("Exception in " + mName + "()"));
            throw e;
        }
    }

    protected void removeRpc(Object service) throws Exception {
        this.removeRpc(service.getClass());
    }

    public void removeRpc(Class cls) throws Exception {
        Object[] delegates;
        Object service = this.serviceInstanceMap.get(cls);
        if (service == null) {
            return;
        }
        Method[] methods = cls.getMethods();
        Method getDelegatesMethod = null;
        Rpc ann = null;
        for (Method method : methods) {
            if (getDelegatesMethod == null && method.getName().equals(GET_DELEGATES_METHOD_NAME) && method.getReturnType().equals(Object[].class) && method.getParameterTypes().length == 0) {
                getDelegatesMethod = method;
            }
            if ((ann = method.getAnnotation(Rpc.class)) == null) continue;
            this.registerMap.remove(this.getKey(cls, method));
        }
        if (getDelegatesMethod != null && (delegates = (Object[])getDelegatesMethod.invoke(service, new Object[0])) != null) {
            for (Object delegate : delegates) {
                this.removeDelegate(service, delegate);
            }
        }
        this.invokeMethod(service, STOP_METHOD_NAME);
    }

    protected void removeDefaultRpc(String defaultPath, Class cls) throws Exception {
        String patternPath = this.getChangePath(defaultPath);
        if (patternPath == null) {
            return;
        }
        Object service = this.serviceInstanceMap.get(cls);
        if (service == null) {
            return;
        }
        if (RpcNaming.getNamingServiceURL() != null) {
            RpcNaming.instance().unregisterDefault(defaultPath, service);
        }
        this.defaultRegisterMap.remove(patternPath);
        this.invokeMethod(service, STOP_METHOD_NAME);
    }

    public RpcRegisterItem getItem(String path, Set<String> argNames) {
        RpcRegisterItem item = this.registerMap.get(this.getKey(path, argNames));
        if (item == null) {
            item = this.registerMap.get(this.getKey(path, null));
        }
        if (item == null) {
            long len = 0L;
            String temp = null;
            for (String defaultKey : this.defaultRegisterMap.keySet()) {
                if (!path.startsWith(defaultKey) || len >= (long)defaultKey.length()) continue;
                len = defaultKey.length();
                temp = defaultKey;
            }
            if (temp != null) {
                item = this.defaultRegisterMap.get(temp);
            }
        }
        return item;
    }

    public void dump(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Method method = null;
        Class<?> cls = null;
        for (RpcRegisterItem call : this.registerMap.values()) {
            method = call.getMethod();
            cls = method.getDeclaringClass();
            out.println("/" + RpcRegister.getRpcServicePath(cls) + "/" + RpcRegister.getMethodRpcName(method) + this.getPrototype(method) + " : " + cls.getName());
        }
        out.println("total: " + this.registerMap.size());
        for (RpcRegisterItem call : this.defaultRegisterMap.values()) {
            method = call.getMethod();
            cls = method.getDeclaringClass();
            out.println("/" + RpcRegister.getRpcServicePath(cls) + "/" + RpcRegister.getMethodRpcName(method) + this.getPrototype(method) + " : " + cls.getName());
        }
        out.println("default total: " + this.defaultRegisterMap.size());
    }

    private String getPrototype(Method method) {
        StringBuilder buf = new StringBuilder();
        Rpc rpc = method.getAnnotation(Rpc.class);
        Class<?>[] cls = method.getParameterTypes();
        String[] args = rpc.args();
        int j = 1;
        buf.append("(");
        for (String arg : args) {
            if (j == cls.length - 1) {
                buf.append(cls[j++].getSimpleName() + " " + arg);
                continue;
            }
            if (j < cls.length) {
                buf.append(cls[j++].getSimpleName() + " " + arg + ", ");
                continue;
            }
            buf.append(", unknow " + arg);
        }
        buf.append(") ");
        cls = method.getExceptionTypes();
        if (cls != null && cls.length > 0) {
            buf.append("throws ");
        }
        j = 0;
        for (Class<?> c : cls) {
            buf.append(c.getSimpleName());
            if (cls.length == ++j) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    void setRpcSecurityChecker(RpcSecurityChecker checker) {
        this.securityChecker = checker;
    }

    RpcSecurityChecker getSecurityChecker() {
        return this.securityChecker;
    }

    boolean hasSecurityChecker() {
        return this.securityChecker != null;
    }

    public static void setSecurityChecker(RpcSecurityChecker checker) {
        instance.setRpcSecurityChecker(checker);
    }

    IUpgradeHandler getRpcUpgradeHandler() {
        return this.upgradeHandler;
    }

    void setRpcUpgradeHandler(IUpgradeHandler upgradeHandler) {
        this.upgradeHandler = upgradeHandler;
    }

    public static void setUpgradeHandler(IUpgradeHandler upgradeHandler) {
        instance.setRpcUpgradeHandler(upgradeHandler);
    }

    static {
        instance = DEFAULT_INSTANCE = new RpcRegister();
        log = LogFactory.getLog(RpcRegister.class);
    }
}

