/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorTimeout;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcPendingRequest {
    private static Log log = LogFactory.getLog(RpcPendingRequest.class);
    private int mid;
    private Map<Integer, RpcPendingRequest> map;
    private String error;
    private RpcMessage response;

    public RpcPendingRequest(int mid, Map<Integer, RpcPendingRequest> map) {
        this.mid = mid;
        this.map = map;
        this.map.put(mid, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RpcMessage getResponse(long timeout) throws Exception {
        RpcPendingRequest rpcPendingRequest = this;
        synchronized (rpcPendingRequest) {
            if (this.response == null && this.error == null) {
                this.wait(timeout);
            }
            if (this.error != null) {
                RpcError rpcError = new RpcError(this.error);
                if (log.isInfoEnabled()) {
                    log.info((Object)"error:", (Throwable)rpcError);
                }
                throw rpcError;
            }
            if (this.response == null) {
                RpcErrorTimeout rpcErrorTimeout = new RpcErrorTimeout();
                if (log.isInfoEnabled()) {
                    log.info((Object)"rpcErrorTimeout:", (Throwable)rpcErrorTimeout);
                }
                throw rpcErrorTimeout;
            }
            return this.response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResponse(RpcMessage message) {
        RpcPendingRequest rpcPendingRequest = this;
        synchronized (rpcPendingRequest) {
            if (message.getType().equals("unknown") && message.hasParameter("error")) {
                this.error = message.getString("error");
            } else {
                this.response = message;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        RpcPendingRequest rpcPendingRequest = this;
        synchronized (rpcPendingRequest) {
            this.error = "Cancelled";
            this.notify();
        }
    }

    void close() {
        this.map.remove(this.mid);
    }
}

