/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcServer;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.Client;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Rpc(name="naming")
public class RpcNamingCache {
    private static Log log = LogFactory.getLog(RpcNamingCache.class);
    public static RpcNamingCache instance = new RpcNamingCache();
    private Map<String, String> namingCache = new ConcurrentHashMap<String, String>();

    public synchronized void stop() {
        this.namingCache.clear();
    }

    @Rpc
    public synchronized void clearCache(RpcContext ctx) {
        this.namingCache.clear();
    }

    @Rpc(args={"clientID"}, export=true)
    public synchronized void initClientProperties(RpcContext ctx, long clientID) {
    }

    @Rpc(export=true)
    public synchronized void getConnectionInfor(RpcContext ctx) {
        try {
            long clientID = Clients.getSocketConnection(ctx.getConnectionID()).getClientID();
            Client client = Clients.getClient(clientID);
            int connectionNumber = 0;
            if (client != null) {
                connectionNumber = client.getConnectionNumber();
            }
            if (connectionNumber > RpcUtil.getMaxClientCount()) {
                ctx.returnParameter("isMetMax", true);
            } else {
                ctx.returnParameter("isMetMax", false);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            ctx.returnParameter("isMetMax", false);
        }
        String[] ips = RpcUtil.getAvailableIP();
        String schema = null;
        SocketConnection socketConn = Clients.getSocketConnection(ctx.getConnectionID());
        HttpServletRequest servletRequest = ctx.getServletRequest();
        if (servletRequest != null) {
            schema = servletRequest.getScheme();
        } else if (socketConn != null) {
            schema = socketConn.getConnector().getProtocol().getSchema();
        } else {
            ctx.returnParameter("availableDS", new String[0]);
            return;
        }
        HashSet<String> availableURISet = new HashSet<String>();
        for (int i = 0; i < ips.length; ++i) {
            String[] urls;
            for (String url : urls = ips[i].split(",")) {
                try {
                    URI uri = null;
                    InetAddress inetAddress = null;
                    try {
                        uri = new URI(url.trim());
                        inetAddress = InetAddress.getByName(uri.getHost());
                    }
                    catch (Exception e) {
                        if (uri == null) continue;
                        log.info((Object)("can't get  InetAddress from " + uri.getHost()));
                        continue;
                    }
                    if (uri == null || !schema.equalsIgnoreCase(uri.getScheme().toLowerCase())) continue;
                    if (!this.hasSamePort(uri.getPort())) {
                        availableURISet.add(url);
                        continue;
                    }
                    if (inetAddress == null || inetAddress.isLoopbackAddress() || RpcUtil.getLocalIPAddressSet().contains(uri.getHost())) continue;
                    availableURISet.add(url);
                }
                catch (Exception ex) {
                    log.debug((Object)"target DS inactive", (Throwable)ex);
                }
            }
        }
        ctx.returnParameter("availableDS", availableURISet.toArray(new String[0]));
    }

    private boolean hasSamePort(int port) {
        List<Integer> ports = RpcServer.getInstance().getOpenPorts();
        for (int onePort : ports) {
            if (onePort != port) continue;
            return true;
        }
        return false;
    }

    public synchronized void put(String name, String location) {
        this.namingCache.put(name, location);
    }

    public synchronized String get(String name) {
        return this.namingCache.get(name);
    }

    public Map<String, String> getNamingCache() {
        return this.namingCache;
    }
}

