/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcResponseGroup;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorTimeout;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcInvoker {
    private static Log log = LogFactory.getLog(RpcInvoker.class);
    private static final int DEF_POOL_SIZE = 100;
    private ExecutorService pool = null;
    public static final RpcInvoker instance = new RpcInvoker();

    void setThreadPool(ExecutorService executor) {
        this.pool = executor;
    }

    public synchronized void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
    }

    protected synchronized void startPool() {
        if (this.pool == null) {
            this.pool = new ThreadPoolExecutor(0, 100, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
    }

    public RpcResponse invokeLocally(RpcRequest request) throws Exception {
        if (this.pool == null) {
            this.startPool();
        }
        Future<RpcResponse> future = this.pool.submit(new LocalCaller(request));
        try {
            return future.get(request.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RpcErrorTimeout();
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof InvocationTargetException) {
                if (ee.getCause() instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)ee.getCause();
                }
                if (ee.getCause().getCause() instanceof AppError) {
                    throw (AppError)ee.getCause().getCause();
                }
                if (ee.getCause().getCause() instanceof RpcError) {
                    throw (RpcError)ee.getCause().getCause();
                }
                throw new RpcError(ee.getCause().getCause());
            }
            if (ee.getCause() instanceof RpcError) {
                throw (RpcError)ee.getCause();
            }
            throw new RpcError(ee.getCause());
        }
    }

    RpcResponseGroup invokeGroup(List<RpcRequest> requests) throws Exception {
        if (this.pool == null) {
            this.startPool();
        }
        ArrayList<RpcCaller> tasks = new ArrayList<RpcCaller>();
        for (RpcRequest request : requests) {
            tasks.add(new RpcCaller(request));
        }
        List<Future<RpcResponse>> results = this.pool.invokeAll(tasks);
        return new RpcResponseGroup(results);
    }

    private static class RpcCaller
    implements Callable<RpcResponse> {
        RpcRequest request;

        RpcCaller(RpcRequest request) {
            this.request = request;
        }

        @Override
        public RpcResponse call() throws Exception {
            return this.request.invoke();
        }
    }

    private class LocalCaller
    implements Callable<RpcResponse> {
        RpcRequest request;

        LocalCaller(RpcRequest request) {
            this.request = request;
        }

        @Override
        public RpcResponse call() throws Exception {
            return this.request.invokeLocally();
        }
    }
}

