/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcEventReceiver;
import com.swimap.base.rpc.RpcEventTarget;
import com.swimap.base.rpc.em.EMRequest;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.dsf.base.rpc.cdr.CdrEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Rpc(name="event")
public class RpcEventSender {
    private static Log log = LogFactory.getLog(RpcEventSender.class);
    public static final RpcEventSender instance = new RpcEventSender();
    private Map<String, RpcEventTarget> targetCache = new ConcurrentHashMap<String, RpcEventTarget>();
    private ExecutorService executor;
    String emURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RpcEventSender rpcEventSender = this;
        synchronized (rpcEventSender) {
            if (this.executor == null) {
                String em = System.getProperty("imap.rpc.em");
                if (em != null && em.startsWith("em")) {
                    this.emURL = em;
                }
                this.executor = Executors.newSingleThreadExecutor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RpcEventSender rpcEventSender = this;
        synchronized (rpcEventSender) {
            if (this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
                this.targetCache.clear();
                log.warn((Object)"Event sender stopped.");
            }
        }
    }

    @Rpc
    public void clearCache(RpcContext ctx) throws Exception {
        this.targetCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(RpcEvent event) {
        RpcEventSender rpcEventSender = this;
        synchronized (rpcEventSender) {
            if (this.executor == null) {
                this.start();
            }
            this.executor.execute(new SenderExecutor(event));
        }
    }

    class SenderExecutor
    implements Runnable {
        private static final String EVENT_RECV_URL = "/event/recv";
        private RpcEvent event;

        SenderExecutor(RpcEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event == null) {
                return;
            }
            try {
                this.sendEvent();
            }
            catch (Exception e) {
                log.error((Object)"send event failed", (Throwable)e);
            }
        }

        protected void sendEvent() throws Exception {
            if (this.event.isLocal()) {
                this.sendLocally();
            } else {
                if (RpcEventSender.this.emURL == null) {
                    throw new Exception("'imap.rpc.em' not set, cannot use EM.");
                }
                this.sendToEM();
            }
        }

        protected void sendLocally() throws Exception {
            RpcEventReceiver.instance.receive(this.event.getMessage());
        }

        protected void sendDirectlly() throws Exception {
            RpcEventTarget targets = (RpcEventTarget)RpcEventSender.this.targetCache.get(this.event.getType());
            if (targets == null) {
                RpcRequest req = RpcNaming.createRequest("imap.event.get");
                req.addArgument("sender", RpcNaming.instance().getLocalURL());
                req.addArgument("type", this.event.getType());
                RpcResponse rsp = req.invoke();
                targets = new RpcEventTarget(rsp.getMessage().getTable("result"));
                RpcEventSender.this.targetCache.put(this.event.getType(), targets);
            }
            String location = null;
            DataTable toTable = null;
            RpcRequest sender = null;
            for (Map.Entry<String, DataTable> entry : targets) {
                location = entry.getKey();
                toTable = entry.getValue();
                sender = RpcRequest.create(location + EVENT_RECV_URL);
                sender.setMessage(this.event.getMessage());
                sender.addTable(toTable);
                sender.invokeOneway();
            }
        }

        protected void sendToEM() throws Exception {
            EMRequest req = EMRequest.getDefault();
            Object cdrEvent = this.event.getMessage().getExtData();
            if (cdrEvent instanceof CdrEvent) {
                req.sendEM((CdrEvent)cdrEvent);
            } else {
                log.warn((Object)"Wrong event type, Reject sending, just surpport CDR event");
            }
        }
    }
}

