/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.PrintEventTypes;
import com.swimap.base.rpc.RpcEventDispatcher;
import com.swimap.base.rpc.RpcEventHandler;
import com.swimap.base.rpc.RpcEventHandlerProxy;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Rpc(name="event")
class RpcEventReceiver {
    private static Log log = LogFactory.getLog(RpcEventReceiver.class);
    private RpcEventDispatcher dispatcher;
    static final RpcEventReceiver instance = new RpcEventReceiver();
    private Map<String, RpcEventHandlerProxy> handlers = new ConcurrentHashMap<String, RpcEventHandlerProxy>();
    private final Map<EventClassType, Set<String>> localSubscriberMap = new HashMap<EventClassType, Set<String>>();

    RpcEventReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RpcEventReceiver rpcEventReceiver = this;
        synchronized (rpcEventReceiver) {
            if (this.dispatcher == null) {
                this.dispatcher = RpcEventDispatcher.getInstance();
                this.dispatcher.start();
            }
            log.warn((Object)"Event receiver started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        RpcEventReceiver rpcEventReceiver = this;
        synchronized (rpcEventReceiver) {
            if (this.dispatcher != null) {
                this.dispatcher.stop();
            }
            log.warn((Object)"Event receiver stoppd.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStarted() {
        RpcEventReceiver rpcEventReceiver = this;
        synchronized (rpcEventReceiver) {
            return this.dispatcher != null;
        }
    }

    public static RpcEventReceiver getInstance() {
        return instance;
    }

    @Rpc(name="recv")
    public void receive(RpcContext ctx) {
        this.receive(ctx.getMessage());
    }

    public void receive(RpcMessage message) {
        RpcEvent event = new RpcEvent(message);
        String eventType = event.getType();
        PrintEventTypes.getInstance().record(eventType);
        this.dispatchEvent(event);
    }

    void dispatchEvent(RpcEvent event) {
        DataTable targetTable = null;
        targetTable = event.isLocal() ? this.getLocalTargetTable(event.getType()) : event.getMessage().getTable("_to");
        if (targetTable != null) {
            for (DataRecord target : targetTable) {
                String tag = target.get(0);
                if (tag == null) continue;
                RpcEventHandlerProxy proxy = this.handlers.get(tag);
                if (proxy != null) {
                    proxy.recevice(event);
                    continue;
                }
                log.warn((Object)("event handler proxy not found: " + tag));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(String target, Object service, Method method, boolean enableCancel) {
        RpcEventHandlerProxy proxy = new RpcEventHandlerProxy(target, new RpcEventHandler(service, method, enableCancel));
        Map<String, RpcEventHandlerProxy> map = this.handlers;
        synchronized (map) {
            this.handlers.put(target, proxy);
        }
    }

    void removeHandler(String target) {
        RpcEventHandlerProxy proxy = this.handlers.remove(target);
        if (proxy != null) {
            proxy.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLocalSubscriber(EventClassType eventType, String subscriber) {
        if (eventType == null || subscriber == null) {
            return;
        }
        Map<EventClassType, Set<String>> map = this.localSubscriberMap;
        synchronized (map) {
            Set<String> targets = this.localSubscriberMap.get(eventType);
            if (targets == null) {
                targets = new HashSet<String>();
                this.localSubscriberMap.put(eventType, targets);
            }
            targets.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalSubscriber(EventClassType eventType, String subscriber) {
        if (eventType == null || subscriber == null) {
            return;
        }
        Map<EventClassType, Set<String>> map = this.localSubscriberMap;
        synchronized (map) {
            Set<String> targets = this.localSubscriberMap.get(eventType);
            if (targets != null) {
                targets.remove(subscriber);
                if (targets.isEmpty()) {
                    this.localSubscriberMap.remove(eventType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable getLocalTargetTable(String eventType) {
        EventClassType eventClassType = EventClassType.createByEventType(eventType);
        Map<EventClassType, Set<String>> map = this.localSubscriberMap;
        synchronized (map) {
            Set<String> targets = this.localSubscriberMap.get(eventClassType);
            if (targets == null) {
                return null;
            }
            DataTable table = new DataTable("_to");
            table.setColumns("tag");
            for (String tag : targets) {
                table.add(tag);
            }
            return table;
        }
    }

    public Map<String, RpcEventHandlerProxy> getEventHandlers() {
        return this.handlers;
    }

    public Map<EventClassType, Set<String>> getLocalSubscriber() {
        return this.localSubscriberMap;
    }
}

