/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcEMHandler;
import com.swimap.base.rpc.RpcEventReceiver;
import com.swimap.base.rpc.em.EMRequest;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcEventManager {
    private static Log log = LogFactory.getLog(RpcEventManager.class);
    public static final String EVENT_SERVICE_NAME = "imap.event";
    public static final String SUB_EVENT_METHOD = "sub";
    public static final String UNSUB_EVENT_METHOD = "unsub";
    public static final String EM_RECONNECT_EVENT = "local.em.reconnect";
    private static final RpcEventManager DEFAULT_INSTANCE;
    private static RpcEventManager instance;
    private List<PendingSubcription> pendingSubscribes = new ArrayList<PendingSubcription>();

    protected RpcEventManager() {
        this.subscribeEmReconnect();
    }

    private void subscribeEmReconnect() {
        try {
            this.subscribeEvent(EM_RECONNECT_EVENT, this, "handleReconnect");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setInstance(RpcEventManager mock) {
        instance = mock == null ? DEFAULT_INSTANCE : mock;
    }

    public static RpcEventManager instance() {
        return instance;
    }

    public RpcEvent createEvent(String eventType) {
        return new RpcEvent(eventType);
    }

    public void subscribeEvent(String eventType, Object service, String methodName) throws Exception {
        this.subscribeEvent(EventClassType.createByEventType(eventType), service, methodName, false);
    }

    public void subscribeEvent(EventClassType eventType, Object service, String methodName, boolean enableCancel) throws Exception {
        log.warn((Object)("subscribeEvent eventType=" + eventType + ", service=" + service + ", methodName=" + methodName));
        Method method = service.getClass().getMethod(methodName, RpcEvent.class);
        String subscriber = RpcEventManager.getHandleEventMethodPath(service, methodName);
        if (eventType.isLocalEvent()) {
            RpcEventReceiver.instance.addLocalSubscriber(eventType, subscriber);
        } else {
            this.sendRequest(SUB_EVENT_METHOD, eventType, subscriber);
        }
        RpcEventReceiver.instance.addHandler(subscriber, service, method, enableCancel);
    }

    public void subscribeSyncEvent(String eventType, Object service, String methodName) throws Exception {
        this.subscribeEvent(eventType, service, methodName);
    }

    public void unsubscribeEvent(String eventType, Object service, String methodName) throws Exception {
        this.unsubscribeEvent(EventClassType.createByEventType(eventType), service, methodName);
    }

    public void unsubscribeEvent(EventClassType eventType, Object service, String methodName) throws Exception {
        log.warn((Object)("unsubscribeEvent eventType=" + eventType + ", service=" + service + ", methodName=" + methodName));
        String subscriber = RpcEventManager.getHandleEventMethodPath(service, methodName);
        if (eventType.isLocalEvent()) {
            RpcEventReceiver.instance.removeLocalSubscriber(eventType, subscriber);
        } else {
            this.sendRequest(UNSUB_EVENT_METHOD, eventType, subscriber);
        }
        RpcEventReceiver.instance.removeHandler(subscriber);
    }

    private static String getHandleEventMethodPath(Object service, String methodName) {
        Rpc ann = service.getClass().getAnnotation(Rpc.class);
        if (ann != null && ann.name().length() > 0) {
            return ann.name().replace('.', '/') + '/' + methodName;
        }
        return service.getClass().getName().replace('.', '/') + '/' + methodName;
    }

    void sendRequest(String method, EventClassType eventType, String subscriber) throws Exception {
        String serviceURL = RpcNaming.instance().lookup(EVENT_SERVICE_NAME);
        boolean sub = method.equals(SUB_EVENT_METHOD);
        if (serviceURL.startsWith("em")) {
            EMRequest req = EMRequest.getDefault();
            if (sub) {
                if (RpcEMHandler.instance.needRequestEM(sub, eventType)) {
                    req.subscribe(eventType);
                }
                RpcEMHandler.instance.addSubscriber(eventType, subscriber);
            } else {
                if (RpcEMHandler.instance.needRequestEM(sub, eventType)) {
                    req.unSubscribe(eventType);
                }
                RpcEMHandler.instance.removeSubscriber(eventType, subscriber);
            }
            log.warn((Object)("EM: request=/" + method + ", eventType=" + eventType + ", subscriber=" + subscriber));
        } else {
            RpcRequest req = RpcRequest.create(serviceURL, method);
            req.addArgument("type", eventType);
            req.addArgument("loc", RpcNaming.instance().getLocalURL());
            req.addArgument("target", subscriber);
            req.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingSubscribe(String eventType, Object service, String methodName, Runnable notifier) {
        List<PendingSubcription> list = this.pendingSubscribes;
        synchronized (list) {
            PendingSubcription ps = new PendingSubcription(eventType, service, methodName, notifier);
            this.pendingSubscribes.add(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReconnect(RpcEvent e) {
        List<PendingSubcription> list = this.pendingSubscribes;
        synchronized (list) {
            log.warn((Object)("handleReconnect: " + this.pendingSubscribes.size()));
            Iterator<PendingSubcription> iter = this.pendingSubscribes.iterator();
            while (iter.hasNext()) {
                if (!this.trySubscribe(iter.next())) continue;
                iter.remove();
            }
        }
    }

    private boolean trySubscribe(PendingSubcription ps) {
        try {
            this.subscribeEvent(ps.eventType, ps.service, ps.methodName);
            log.warn((Object)("PendingRequest resubscribe success: " + ps));
            if (null != ps.notifier) {
                ps.notifier.run();
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"Could not resubscribe pending em subscribe", (Throwable)ex);
            return false;
        }
    }

    public List<PendingSubcription> getPendingSubcription() {
        return this.pendingSubscribes;
    }

    static {
        instance = DEFAULT_INSTANCE = new RpcEventManager();
    }

    class PendingSubcription {
        private String eventType;
        private Object service;
        private String methodName;
        private Runnable notifier;

        PendingSubcription(String eventType, Object service, String methodName, Runnable notifier) {
            this.eventType = eventType;
            this.service = service;
            this.methodName = methodName;
            this.notifier = notifier;
        }

        public String toString() {
            return this.eventType + ":" + this.service.getClass() + ":" + this.methodName;
        }
    }
}

