/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcEventDispatcher;
import com.swimap.base.rpc.RpcEventHandler;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RpcEventHandlerProxy
implements Runnable {
    private static Log log = LogFactory.getLog(RpcEventHandlerProxy.class);
    private String target;
    private RpcEventDispatcher dispatcher;
    private RpcEventHandler handler;
    private static final int EVENT_STACK_NUMBER = 20;
    private static final int EVENT_NUMBER_INTERVAL = 10;
    private boolean traceFlag = true;
    private int intervalNumberCount = 10;
    private LinkedList<RpcEvent> eventlist = new LinkedList();
    private boolean enableCancel = false;
    private static final int EVENT_CANCEL_NUMBER = 200;
    private static final int MAX_CACHE_SIZE_MEMORY_HIGH = Integer.MAX_VALUE;
    private static final int MAX_CACHE_SIZE_MEMORY_LOW = 5000;
    private boolean isRunning = false;

    RpcEventHandlerProxy(String target, RpcEventHandler handler) {
        this.target = target;
        this.handler = handler;
        this.dispatcher = RpcEventDispatcher.getInstance();
        this.enableCancel = handler.enableCancel;
    }

    public String getHandlerName() {
        return this.handler.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recevice(RpcEvent event) {
        LinkedList<RpcEvent> linkedList = this.eventlist;
        synchronized (linkedList) {
            if (this.enableCancel && this.eventlist.size() >= 200) {
                log.warn((Object)("Event proxy | cancel the event type = " + this.target));
                this.eventlist.clear();
            }
            if (!this.isRunning && this.eventlist.isEmpty()) {
                this.eventlist.offer(event);
                this.dispatcher.registerProxy(this);
            } else {
                if (!RpcUtil.checkQueue(this.eventlist, Integer.MAX_VALUE, 5000)) {
                    log.warn((Object)("Event proxy | clear the event type = " + this.target));
                    this.eventlist.clear();
                }
                this.eventlist.offer(event);
                int size = 0;
                size = this.eventlist.size();
                if (size > 20) {
                    if (this.traceFlag) {
                        log.warn((Object)("Event proxy | target = " + this.target + " | " + " | block number " + size));
                        this.traceFlag = false;
                    } else {
                        ++this.intervalNumberCount;
                        if (this.intervalNumberCount > 10) {
                            this.intervalNumberCount = 0;
                            this.traceFlag = true;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        while (true) {
            RpcEvent event;
            LinkedList<RpcEvent> linkedList = this.eventlist;
            synchronized (linkedList) {
                event = this.eventlist.poll();
            }
            this.handleEvent(event);
            linkedList = this.eventlist;
            synchronized (linkedList) {
                if (this.eventlist.isEmpty()) {
                    this.isRunning = false;
                    break;
                }
            }
        }
    }

    private void handleEvent(RpcEvent event) {
        if (event != null) {
            try {
                this.handler.handleEvent(event);
            }
            catch (Exception e) {
                log.debug((Object)"handle event failed", (Throwable)e);
            }
        }
    }

    public LinkedList<RpcEvent> getEvenList() {
        return this.eventlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<RpcEvent> linkedList = this.eventlist;
        synchronized (linkedList) {
            this.eventlist.clear();
        }
    }
}

