/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RpcEventHandler {
    private static Log log = LogFactory.getLog(RpcEventHandler.class);
    Object service;
    Method method;
    boolean enableCancel = false;

    RpcEventHandler(Object service, Method method) {
        this(service, method, false);
    }

    RpcEventHandler(Object service, Method method, boolean enableCancel) {
        this.service = service;
        this.method = method;
        this.enableCancel = enableCancel;
    }

    public String getName() {
        return this.service.getClass() + this.method.getName();
    }

    void handleEvent(RpcEvent event) {
        try {
            this.method.invoke(this.service, event);
        }
        catch (InvocationTargetException ite) {
            log.error((Object)"invoke handle event method failed", ite.getTargetException());
        }
        catch (Exception e) {
            log.error((Object)"invoke handle event method failed", (Throwable)e);
        }
    }
}

