/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.monitor.ThreadCheckManager;
import com.swimap.base.framework.monitor.ThreadChecker;
import com.swimap.base.rpc.RpcEventHandlerProxy;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcEventDispatcher
implements Runnable,
ThreadChecker {
    private static Log log = LogFactory.getLog(RpcEventDispatcher.class);
    private final Object mutex = new Object();
    private Boolean running = false;
    private Thread selectThread;
    private ThreadPoolExecutor eventThreadPool;
    private LinkedBlockingQueue<RpcEventHandlerProxy> handlerProxys = new LinkedBlockingQueue();
    private static RpcEventDispatcher instance;

    static RpcEventDispatcher getInstance() {
        if (instance == null) {
            instance = new RpcEventDispatcher();
        }
        return instance;
    }

    private RpcEventDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mutex;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running.booleanValue()) {
                return;
            }
            this.running = true;
            if (this.eventThreadPool == null) {
                this.eventThreadPool = ThreadPoolManager.getInstance().getEventThreadPool();
            }
            this.selectThread = new Thread((Runnable)this, "rpc_event_dispatcher");
            this.selectThread.start();
            ThreadCheckManager.getInstance().registerChecker(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.running = false;
        }
        if (this.eventThreadPool != null) {
            this.eventThreadPool.shutdown();
        }
        ThreadCheckManager.getInstance().unregisterChecker(this);
    }

    void registerProxy(RpcEventHandlerProxy proxy) {
        try {
            this.handlerProxys.put(proxy);
        }
        catch (InterruptedException e) {
            log.error((Object)"register event proxy failed");
        }
    }

    @Override
    public void run() {
        while (this.running.booleanValue()) {
            try {
                RpcEventHandlerProxy proxy = this.handlerProxys.take();
                this.eventThreadPool.execute(proxy);
            }
            catch (Exception e) {
                log.error((Object)"event dispatcher error", (Throwable)e);
            }
        }
        log.fatal((Object)"This should never happen, thread will be terminated!");
    }

    @Override
    public boolean check() {
        return this.selectThread.getState() == Thread.State.TERMINATED;
    }

    @Override
    public String getThreadName() {
        return this.selectThread.getName();
    }
}

