/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.EventClassTypeUtil;
import com.swimap.base.rpc.RpcEventReceiver;
import com.swimap.base.rpc.em.IEMListener;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.cdr.CdrEvent;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RpcEMHandler
implements IEMListener {
    private static Log log = LogFactory.getLog(RpcEMHandler.class);
    private static final String EVENT_RECEIVER_PATH = "/event/recv";
    static final RpcEMHandler instance = new RpcEMHandler();
    private final Map<EventClassType, Set<String>> subscriberMap = new ConcurrentHashMap<EventClassType, Set<String>>();
    private Map<String, RpcEvent.IEventParser> parserMap = new ConcurrentHashMap<String, RpcEvent.IEventParser>();

    private RpcEMHandler() {
    }

    public static RpcEMHandler getInstance() {
        return instance;
    }

    public void addEventParser(String sourceClass, RpcEvent.IEventParser parser) {
        if (sourceClass != null && parser != null) {
            this.parserMap.put(sourceClass, parser);
        }
    }

    public void removeEventParser(String sourceClass) {
        if (sourceClass != null) {
            this.parserMap.remove(sourceClass);
        }
    }

    @Override
    public void handlePDU(SocketConnection conn, CdrEvent event) throws Exception {
        if (event != null) {
            RpcEvent.IEventParser parser = this.parserMap.get(event.getSourceClass());
            RpcMessage message = new RpcMessage("event");
            if (parser != null) {
                RpcEvent e = parser.parse(event);
                if (e == null) {
                    log.error((Object)(parser + " parser return null, discard " + event.getEventClassType() + " CdrEvent."));
                    return;
                }
                message = e.getMessage();
            } else {
                message.setExtData(event);
                EventClassType eventClassType = event.getEventClassType();
                EventClassTypeUtil.setCdrEventClassType2RpcEventMessage(eventClassType, message);
            }
            message.addTable(this.getTargetTable(event.getEventClassType()));
            RpcEventReceiver.instance.receive(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSubscriber(EventClassType eventType, String subscriber) {
        if (eventType == null || subscriber == null) {
            return;
        }
        Map<EventClassType, Set<String>> map = this.subscriberMap;
        synchronized (map) {
            Set<String> targets = this.subscriberMap.get(eventType);
            if (targets == null) {
                targets = new HashSet<String>();
                this.subscriberMap.put(eventType, targets);
            }
            targets.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscriber(EventClassType eventType, String subscriber) {
        if (eventType == null || subscriber == null) {
            return;
        }
        Map<EventClassType, Set<String>> map = this.subscriberMap;
        synchronized (map) {
            Set<String> targets = this.subscriberMap.get(eventType);
            if (targets != null) {
                targets.remove(subscriber);
                if (targets.isEmpty()) {
                    this.subscriberMap.remove(eventType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTable getTargetTable(EventClassType eventType) {
        Map<EventClassType, Set<String>> map = this.subscriberMap;
        synchronized (map) {
            String type;
            Set<String> targets = this.subscriberMap.get(eventType);
            if (targets == null) {
                targets = new HashSet<String>();
            }
            DataTable table = new DataTable("_to");
            table.setColumns("tag");
            for (String tag : targets) {
                table.add(tag);
            }
            String sourceClass = eventType.getSourceClass();
            Set<String> regex = this.subscriberMap.get(new EventClassType(sourceClass, "*"));
            if (regex != null) {
                for (String tag : regex) {
                    table.add(tag);
                }
            }
            if ((regex = this.subscriberMap.get(new EventClassType("*", "*"))) != null) {
                for (String tag : regex) {
                    table.add(tag);
                }
            }
            if ((regex = this.subscriberMap.get(new EventClassType("*", type = eventType.getEventType()))) != null) {
                for (String tag : regex) {
                    table.add(tag);
                }
            }
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needRequestEM(boolean sub, EventClassType eventType) {
        Map<EventClassType, Set<String>> map = this.subscriberMap;
        synchronized (map) {
            if (sub) {
                return !this.subscriberMap.containsKey(eventType);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            Set<String> targets = this.subscriberMap.get(eventType);
            return targets != null && targets.size() == 1;
        }
    }

    Map<EventClassType, Set<String>> GetSubscribers() {
        return this.subscriberMap;
    }

    Map<String, RpcEvent.IEventParser> getParserMap() {
        return this.parserMap;
    }
}

