/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.Framework;
import com.swimap.base.framework.monitor.Kpi;
import com.swimap.base.framework.monitor.KpiManagement;
import com.swimap.base.rpc.IEC;
import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.base.rpc.RpcSocketProtocolTCP;
import com.swimap.base.rpc.RpcSocketProtocolTCPSsl;
import com.swimap.base.rpc.WebConnector;
import com.swimap.base.rpc.WebConnectorSsl;
import com.swimap.base.rpc.nio.IConnector;
import com.swimap.base.rpc.nio.SocketConnector;
import com.swimap.base.rpc.nio.SocketServerConnector;
import com.swimap.external.sf.ssl.CipherMapping;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class RpcConnectorManager {
    public static final String HTTPS = "https";
    public static final String HTTP = "http";
    public static final String TCP = "tcp";
    public static final String TCPS = "tcps";
    public static final String MDP = "mdp";
    public static final String MDPS = "mdps";
    private static final String RESTRICTED = "/restricted";
    private static final String PROPERTY_CONNECTORS = "imap.rpc.connectors";
    private static final String PROPERTY_BASEPORT = "baseport";
    private static final String CONNECTION_MODE = "imap.connection.mode";
    private static final String CORBA_DEFAULT_PORT = "31036";
    private static Log log = LogFactory.getLog(RpcConnectorManager.class);
    private List<Connector> webConnectors = new ArrayList<Connector>();
    private List<SocketConnector> socketConnectors = new ArrayList<SocketConnector>();
    private List<IConnector> connectors = new ArrayList<IConnector>();
    private List<Integer> ports = new ArrayList<Integer>();
    private int mode = 0;
    private int baseport = -1;

    RpcConnectorManager() throws Exception {
        String connectorConfig = System.getProperty(PROPERTY_CONNECTORS);
        String connectionMode = System.getProperty(CONNECTION_MODE);
        try {
            this.baseport = Integer.valueOf(System.getProperty(PROPERTY_BASEPORT));
            System.setProperty("imap.rpc.orb.port", String.valueOf(this.baseport - 1));
        }
        catch (NumberFormatException e) {
            this.baseport = -1;
            System.setProperty("imap.rpc.orb.port", CORBA_DEFAULT_PORT);
        }
        if (connectorConfig == null || "".equals(connectorConfig)) {
            log.warn((Object)"property 'imap.rpc.connectors' not set or empty.");
            return;
        }
        this.initConnectionMode(connectionMode);
        String localhost = System.getenv("LOCALHOST_FLOATSERVERNAME");
        if (!this.isListenAllIp() && localhost != null && !"".equals(localhost.trim())) {
            connectorConfig = connectorConfig.replaceAll("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", localhost);
        }
        String[] connectorstr = connectorConfig.split(",");
        for (int i = 0; i < connectorstr.length; ++i) {
            this.add(connectorstr[i].trim());
        }
        KpiManagement.getInstance().registerKpi("DSF", new Kpi("DSWebConnectors"){

            @Override
            public String getKpiValue() {
                StringBuilder ss = new StringBuilder();
                Connector[] connectors = RpcConnectorManager.this.webConnectors.toArray(new Connector[0]);
                for (int i = 0; i < connectors.length; ++i) {
                    ss.append(connectors[i].getName()).append("|");
                }
                return ss.toString();
            }

            @Override
            public String getDescription() {
                return "DS http connectors information.";
            }
        });
        KpiManagement.getInstance().registerKpi("DSF", new Kpi("DSTcpConnectors"){

            @Override
            public String getKpiValue() {
                StringBuilder ss = new StringBuilder();
                SocketConnector[] connectors = RpcConnectorManager.this.socketConnectors.toArray(new SocketConnector[0]);
                for (int i = 0; i < connectors.length; ++i) {
                    ss.append(connectors[i].toString()).append("|");
                }
                return ss.toString();
            }

            @Override
            public String getDescription() {
                return "DS tcp connectors information.";
            }
        });
        KpiManagement.getInstance().registerKpi("DSF", new Kpi("DSAllConnectors"){

            @Override
            public String getKpiValue() {
                StringBuilder ss = new StringBuilder();
                IConnector[] allconnectors = RpcConnectorManager.this.connectors.toArray(new IConnector[0]);
                for (int i = 0; i < allconnectors.length; ++i) {
                    try {
                        ss.append(allconnectors[i].getURI().toString()).append("|");
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return ss.toString();
            }

            @Override
            public String getDescription() {
                return "DS all connectors information.";
            }
        });
    }

    private boolean isListenAllIp() {
        boolean isListenAllIp = true;
        try {
            String imapCfg = System.getProperty("imapcfgpath");
            Properties prop = FileUtil.loadProperties(imapCfg);
            String listenAllIp = prop.getProperty("ListenAllIp");
            if (listenAllIp != null && Integer.parseInt(listenAllIp.trim()) == 0) {
                isListenAllIp = false;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return isListenAllIp;
    }

    void initConnectionMode(String connectionMode) {
        try {
            this.mode = Integer.valueOf(connectionMode);
        }
        catch (Exception e) {
            this.mode = 0;
        }
        if (this.mode != 1 && this.mode != 2) {
            this.mode = 0;
        }
    }

    void add(String url) throws Exception {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid connector URL, " + e + " : " + url));
            return;
        }
        boolean isRestricted = uri.getPath().endsWith(RESTRICTED);
        if (uri.getScheme().equalsIgnoreCase(HTTP)) {
            if (this.mode == 2) {
                return;
            }
            int val = this.baseport + 1;
            int port = this.baseport != -1 && !this.ports.contains(val) ? val : uri.getPort();
            WebConnector connector = new WebConnector(uri.getHost(), port, isRestricted);
            this.portCheck(connector);
            this.webConnectors.add((Connector)connector);
            this.connectors.add(connector);
            this.ports.add(connector.getPort());
        } else if (uri.getScheme().equalsIgnoreCase(HTTPS)) {
            if (this.mode == 0) {
                return;
            }
            int val = this.baseport + 3;
            int port = this.baseport != -1 && !this.ports.contains(val) ? val : uri.getPort();
            SSLContext context = Framework.getSSLcontext();
            if (context == null) {
                FrameInformationManager.getInstance().record("HTTP SSL", "Checking whether HTTPS SSL config exist", false);
                InternalErrorUtil.printInternalError(HTTPS, 0xC0000BC, IEC.getErrorDesc(0xC0000BC));
            }
            SslContextFactory mySslContextFactory = new SslContextFactory();
            WebConnectorSsl connector = new WebConnectorSsl(uri.getHost(), port, isRestricted, mySslContextFactory);
            mySslContextFactory.setSslContext(context);
            String encryptLevel = System.getProperty("imap.ssl.encryptLevel", "high");
            if ("".equals(encryptLevel)) {
                encryptLevel = "high";
            }
            boolean isLoadDH = "true".equals(System.getProperty("imap.ssl.loadDH", "false"));
            mySslContextFactory.setIncludeCipherSuites(CipherMapping.getCipherList((String)encryptLevel, (boolean)isLoadDH));
            String authPeer = System.getProperty("imap.ssl.authPeer", "false");
            if ("true".equals(authPeer)) {
                mySslContextFactory.setNeedClientAuth(true);
            }
            this.portCheck(connector);
            this.webConnectors.add((Connector)connector);
            this.connectors.add(connector);
            this.ports.add(connector.getPort());
        } else if (uri.getScheme().equalsIgnoreCase(TCP)) {
            if (this.mode == 2) {
                return;
            }
            int port = this.baseport != -1 && !this.ports.contains(this.baseport) ? this.baseport : uri.getPort();
            SocketServerConnector connector = new SocketServerConnector(null, new RpcSocketProtocolTCP(), uri.getHost(), port, isRestricted);
            this.portCheck(connector);
            this.socketConnectors.add(connector);
            this.connectors.add(connector);
            this.ports.add(connector.getPort());
        } else if (uri.getScheme().equalsIgnoreCase(TCPS)) {
            if (this.mode == 0) {
                return;
            }
            int val = this.baseport + 2;
            int port = this.baseport != -1 && !this.ports.contains(val) ? val : uri.getPort();
            SSLContext context = Framework.getSSLcontext();
            if (context == null) {
                FrameInformationManager.getInstance().record("TCP SSL", "Checking whether TCP SSL config is ok", false);
                InternalErrorUtil.printInternalError(TCPS, 0xC0000BC, IEC.getErrorDesc(0xC0000BC));
            }
            SocketServerConnector connector = new SocketServerConnector(context, new RpcSocketProtocolTCPSsl(), uri.getHost(), port, isRestricted);
            this.portCheck(connector);
            this.socketConnectors.add(connector);
            this.connectors.add(connector);
            this.ports.add(connector.getPort());
        } else {
            log.error((Object)("Invalid connector, unsupported protocol : " + url));
        }
        FrameInformationManager.getInstance().record("Listening Ports", Arrays.toString(this.ports.toArray()));
    }

    boolean hasSocketConnector() {
        return !this.socketConnectors.isEmpty();
    }

    Collection<SocketConnector> getSocketConnectors() {
        return this.socketConnectors;
    }

    boolean hasWebConnector() {
        return !this.webConnectors.isEmpty();
    }

    Collection<Connector> getWebConnectors() {
        return this.webConnectors;
    }

    String getLocalURL() throws Exception {
        if (this.connectors.isEmpty()) {
            return "";
        }
        for (IConnector connector : this.connectors) {
            if (connector.isRestricted()) continue;
            return connector.getURI().toString();
        }
        return this.connectors.get(0).getURI().toString();
    }

    List<Integer> getPortList() {
        return this.ports;
    }

    int getBasePort() {
        return this.baseport;
    }

    int getConnectionMode() {
        return this.mode;
    }

    private void portCheck(IConnector connector) throws BindException {
        for (int port : this.ports) {
            if (port != connector.getPort()) continue;
            FrameInformationManager.getInstance().record("Listening Ports", String.format("Checking whether port is avalible:%d", port), false);
            throw new BindException("Address already in use: bind " + port);
        }
        int port = connector.getPort();
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (Exception e) {
            FrameInformationManager.getInstance().record("Listening Ports", "Checking whether port is avalible:" + port, false);
            throw new BindException("Address already in use: bind " + port);
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                    server = null;
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }
}

