/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.IRpcAssistPoolManagerHelper;
import com.swimap.base.rpc.RpcAssistPoolManagerHelper;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.nio.ISocketPDU;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcAssistPoolManager {
    private static Log log = LogFactory.getLog(RpcAssistPoolManager.class);
    private static RpcAssistPoolManager instance = new RpcAssistPoolManager();
    private List<String> loginPathList = new Vector<String>();
    private List<String> alarmPathList = new Vector<String>();
    public static final String POOL_NAME_ALARM = "alarm_pool";
    public static final String POOL_NAME_LOGIN = "login_pool";
    private IRpcAssistPoolManagerHelper helper = new RpcAssistPoolManagerHelper();

    public static RpcAssistPoolManager getInstance() {
        return instance;
    }

    private RpcAssistPoolManager() {
    }

    void setHelper(IRpcAssistPoolManagerHelper helper) {
        this.helper = helper;
    }

    void clear() {
        this.loginPathList = new Vector<String>();
        this.alarmPathList = new Vector<String>();
        this.helper = new RpcAssistPoolManagerHelper();
    }

    private IRpcAssistPoolManagerHelper getHelper() {
        return this.helper;
    }

    public void register(String poolName, String ... rpcPaths) {
        log.error((Object)String.format("RpcAssistPoolManager register poolName=%s rpcPath=%s", poolName, Arrays.toString(rpcPaths)));
        if (poolName == null || rpcPaths == null) {
            return;
        }
        if (POOL_NAME_ALARM.equals(poolName)) {
            for (String path : rpcPaths) {
                if (path == null) continue;
                this.alarmPathList.add(path);
            }
        }
        if (POOL_NAME_LOGIN.equals(poolName)) {
            for (String path : rpcPaths) {
                if (path == null) continue;
                this.loginPathList.add(path);
            }
        }
    }

    public void register(String poolName, List<String> pathList) {
        log.warn((Object)String.format("RpcAssistPoolManager register poolName=%s pathList=%s", poolName, pathList));
        if (poolName == null || pathList == null) {
            return;
        }
        String[] lines = RpcAssistPoolManager.list2StringArray(pathList);
        this.register(poolName, lines);
    }

    private static String[] list2StringArray(List<String> list) {
        String[] lines = new String[list.size()];
        lines = list.toArray(lines);
        return lines;
    }

    public void registerByService(String poolName, Class<?> service) {
        if (poolName == null || service == null) {
            log.error((Object)String.format("RpcAssistPoolManager register poolName=%s service=%s", poolName, service));
            return;
        }
        List<String> pathArray = this.getHelper().getServicePath(service);
        log.warn((Object)String.format("RpcAssistPoolManager poolName=%s, service=%s, pathArray=%s", poolName, service, pathArray));
        this.register(poolName, pathArray);
    }

    public boolean dispatch(ISocketPDU pdu, Runnable runnable) {
        RpcSocketPDU rpcSocketPDU;
        return this.getHelper().isAllTaskPoolThreadRunning() && pdu instanceof RpcSocketPDU && (this.isLoginPDU(rpcSocketPDU = (RpcSocketPDU)pdu) ? this.getHelper().dispatchLogin(runnable) : this.isAlarmPDU(rpcSocketPDU) && this.getHelper().dispatchAlarm(runnable));
    }

    private boolean isLoginPDU(RpcSocketPDU rpcSocketPDU) {
        String path = rpcSocketPDU.getPath();
        return this.loginPathList.contains(path);
    }

    private boolean isAlarmPDU(RpcSocketPDU rpcSocketPDU) {
        String path = rpcSocketPDU.getPath();
        return this.alarmPathList.contains(path);
    }
}

