/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.framework.Framework;
import com.swimap.base.rpc.IRpcAcceptProtectHelper;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcAcceptProtectHelper
implements IRpcAcceptProtectHelper {
    private static Log log = LogFactory.getLog(RpcAcceptProtectHelper.class);
    public String fileName = Framework.getConfigDir().getAbsolutePath() + "/invalidip.txt";
    private Set<String> setOld = new HashSet<String>();

    void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public List<String> getInvalidIPAddressList() {
        List<String> tempLines = new Vector<String>();
        try {
            if (FileUtil.checkReadFile(this.fileName)) {
                tempLines = FileUtil.readLines(this.fileName);
            }
            if (this.isNeedClearAcceptThreadPool(tempLines)) {
                ThreadPoolManager.getInstance().getAcceptThreadPool().getQueue().clear();
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return tempLines;
    }

    boolean isNeedClearAcceptThreadPool(List<String> lines) {
        boolean isNeedClearAcceptThreadPool = false;
        try {
            HashSet<String> setNew = new HashSet<String>();
            if (lines != null) {
                setNew.addAll(lines);
            }
            if (!setNew.isEmpty() && !((Object)setNew).equals(this.setOld)) {
                isNeedClearAcceptThreadPool = true;
            }
            this.setOld = setNew;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return isNeedClearAcceptThreadPool;
    }
}

