/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.IRpcAcceptProtectHelper;
import com.swimap.base.rpc.RpcAcceptProtectHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcAcceptProtect {
    private static Log log = LogFactory.getLog(RpcAcceptProtect.class);
    private static RpcAcceptProtect instance = new RpcAcceptProtect();
    private List<String> refuseIPAddressList = new Vector<String>();
    private IRpcAcceptProtectHelper helper = new RpcAcceptProtectHelper();

    private RpcAcceptProtect() {
    }

    private synchronized IRpcAcceptProtectHelper getHelper() {
        if (this.helper == null) {
            this.helper = new RpcAcceptProtectHelper();
        }
        return this.helper;
    }

    public void setHelper(IRpcAcceptProtectHelper helper) {
        this.helper = helper;
    }

    public static RpcAcceptProtect getInstance() {
        return instance;
    }

    public boolean enableAccept(String ipAddress) {
        if (this.refuseIPAddressList != null) {
            boolean enableAccept;
            boolean bl = enableAccept = !this.refuseIPAddressList.contains(ipAddress);
            if (!enableAccept && log.isInfoEnabled()) {
                log.info((Object)("enableAccept refuse " + ipAddress));
            }
            return enableAccept;
        }
        return true;
    }

    public void setRefuseIPAddressList(List<String> refuseIPAddressList) {
        this.refuseIPAddressList = refuseIPAddressList;
    }

    public void readInvalidIPAddressList() {
        List<String> lines = this.getHelper().getInvalidIPAddressList();
        if (lines != null && lines.size() != 0) {
            log.error((Object)("readInvalidIPAddressList: lines=" + Arrays.toString(lines.toArray())));
        }
        this.setRefuseIPAddressList(lines);
    }
}

