/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrintEventTypes
extends TimerTask {
    private static final long LOG_PRINT_PERIOD = 30000L;
    public Long starttime = System.currentTimeMillis();
    private static Log log = LogFactory.getLog(PrintEventTypes.class);
    private Map<String, List<Long>> eventTypeCache = new ConcurrentHashMap<String, List<Long>>();
    private static PrintEventTypes instance = new PrintEventTypes();

    private PrintEventTypes() {
        Timer timer = new Timer("PrintEvents");
        timer.schedule((TimerTask)this, 0L, 30000L);
    }

    public static PrintEventTypes getInstance() {
        return instance;
    }

    public synchronized Map<String, List<Long>> getEventTypeCache() {
        Map<String, List<Long>> tmp = this.eventTypeCache;
        this.eventTypeCache = new ConcurrentHashMap<String, List<Long>>();
        return tmp;
    }

    public synchronized void record(String eventType) {
        if (eventType == null) {
            return;
        }
        if (this.eventTypeCache.containsKey(eventType)) {
            this.eventTypeCache.get(eventType).add(System.currentTimeMillis() - this.starttime);
        } else {
            List<Long> intervalList = Collections.synchronizedList(new LinkedList());
            intervalList.add(System.currentTimeMillis() - this.starttime);
            this.eventTypeCache.put(eventType, intervalList);
        }
    }

    @Override
    public void run() {
        try {
            long starttimeTmp = this.starttime;
            this.starttime = System.currentTimeMillis();
            Map<String, List<Long>> eventTypeCache = this.getEventTypeCache();
            StringBuilder sb = new StringBuilder();
            sb.append("starttime:" + starttimeTmp);
            for (String eventType : eventTypeCache.keySet()) {
                sb.append("\n" + eventType + ": ");
                List<Long> timeList = eventTypeCache.get(eventType);
                for (Long interval : timeList) {
                    sb.append(interval + ", ");
                }
                timeList.clear();
                timeList = null;
            }
            log.warn((Object)sb.toString());
            eventTypeCache.clear();
            Object var3_3 = null;
        }
        catch (Exception e) {
            log.warn((Object)"PrintEventTypes have problem.", (Throwable)e);
        }
    }
}

