/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FileUtil;
import com.swimap.base.rpc.INATUtillityHelper;
import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NATUtilityHelper
implements INATUtillityHelper {
    private static Log log = LogFactory.getLog(NATUtilityHelper.class);

    @Override
    public byte[] convertHost2ByteArray(String host) throws UnknownHostException {
        InetAddress ip = InetAddress.getByName(host);
        byte[] bytes = ((Inet4Address)ip).getAddress();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getIPMapLines(URI dsURI) {
        Vector<String> ipMapLines = new Vector<String>();
        try {
            RpcRequest request = null;
            request = dsURI == null ? RpcRequest.byName("naming.natService.getIPAddressArray") : RpcRequest.create(dsURI.getScheme() + "://" + dsURI.getHost() + ":" + dsURI.getPort() + "/naming/natService/getIPAddressArray", RpcNaming.getSSLContext());
            RpcResponse rsp = request.invoke();
            RpcMessage msg = rsp.getMessage();
            String[] ipMapLinesArray = msg.getStringArray("content");
            ipMapLines.addAll(Arrays.asList(ipMapLinesArray));
        }
        catch (RpcError e) {
            InternalErrorUtil.printInternalError("DSF", e);
        }
        catch (Exception e) {
            log.error((Object)"Error while getting ipArray:-", (Throwable)e);
        }
        finally {
            log.warn((Object)("getIPMapLines end: ipArray=" + Arrays.toString(ipMapLines.toArray())));
        }
        return ipMapLines;
    }

    @Override
    public String getUsage() {
        Properties prop = FileUtil.loadProperties("ipusage.cfg");
        String usage = prop.getProperty("ipusage");
        usage = usage == null ? "" : usage;
        log.warn((Object)("getUsage:" + usage));
        return usage;
    }
}

