/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.IEC;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.mrb.CdrResponse;
import com.swimap.external.dsf.base.rpc.mrb.MRB;
import imap.iMAPcommon.StringSeqHolder;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.portable.Streamable;

@Rpc(export=true, name="naming.natService")
public class NATUtilService {
    private static Log log = LogFactory.getLog(NATUtilService.class);
    private static final int CMD_SYSMGR_GETIPARRAY = 98027;
    private static final int ERROR_CODE_SUCCESS = 0;
    private static final String SERVICENAME = "SystemService";
    private String[] backupIPAddressArray;

    public void start() {
        try {
            RpcNaming.instance().register(this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        try {
            RpcNaming.instance().unregister(this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Rpc(export=true)
    public void getIPAddressArray(RpcContext ctx) throws Exception {
        try {
            String[] ipAddressArray = this.getIPAddressArrayEx();
            if (ipAddressArray != null) {
                this.backupIPAddressArray = ipAddressArray;
            }
            ctx.returnParameter("content", ipAddressArray);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            if (this.backupIPAddressArray != null) {
                log.warn((Object)String.format("getIPAddressArray failed, using backupIPAddressArray(%s).", Arrays.toString(this.backupIPAddressArray)));
                ctx.returnParameter("content", this.backupIPAddressArray);
            }
            log.warn((Object)"getIPAddressArray failed, using backupIPAddressArray is also null.");
            ctx.returnParameter("content", null);
            int errcode = 201334785;
            ctx.returnInternalError(errcode, IEC.getErrorDesc(errcode));
        }
    }

    private String[] getIPAddressArrayEx() throws Exception {
        Object[] ipAddressArray = null;
        CdrResponse rsp = MRB.getDefault().invoke(SERVICENAME, 98027, new Streamable[0]);
        StringSeqHolder stringArrayHolder = new StringSeqHolder();
        rsp.getOutput(0, (Streamable)stringArrayHolder);
        int errorCode = rsp.getErrorCode();
        if (errorCode != 0 || stringArrayHolder.value == null) {
            log.warn((Object)String.format("getIPAddressArrayEx failed errorCode=%s", errorCode));
            throw new Exception(String.format("getIPAddressArrayEx failed errorCode=%s and stringArrayHolder.value=%s", errorCode, Arrays.toString(stringArrayHolder.value)));
        }
        ipAddressArray = stringArrayHolder.value;
        log.warn((Object)String.format("getIPAddressArray ipAddressArray=%s.", Arrays.toString(ipAddressArray)));
        return ipAddressArray;
    }
}

