/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MessageHandler
extends DefaultHandler {
    private static final String NAME = "name";
    private static final String RECORD_TAG = "object";
    private static final String TABLE_TAG = "class";
    private RpcMessage message = new RpcMessage();
    private Stack<Object> stack = new Stack();

    MessageHandler() {
    }

    RpcMessage getMessage() {
        return this.message;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("response") || qName.equals("request") || qName.equals("exception") || qName.equals("event")) {
            this.startMessage(qName, attributes);
        } else if (qName.equals(TABLE_TAG)) {
            this.startDataTable(attributes);
        } else if (qName.equals(RECORD_TAG)) {
            this.startDataRecord(attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("response") || qName.equals("request") || qName.equals("exception") || qName.equals("event")) {
            this.endMessage();
        } else if (qName.equals(TABLE_TAG)) {
            this.endDataTable();
        } else if (qName.equals(RECORD_TAG)) {
            this.endDataRecord();
        }
    }

    protected void startMessage(String type, Attributes attributes) {
        this.message.setType(type);
        if (attributes == null) {
            return;
        }
        String name = null;
        String value = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            name = attributes.getQName(i);
            if (this.message.setInternalParameter(name, value = attributes.getValue(i))) continue;
            this.message.addParameter(name, value);
        }
    }

    protected void startDataTable(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        DataTable table = new DataTable(attributes.getValue(NAME));
        String name = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            name = attributes.getQName(i);
            if (name.equals(NAME)) continue;
            table.addParameter(name, attributes.getValue(i));
        }
        this.stack.push(table);
    }

    protected void startDataRecord(Attributes attributes) {
        DataTable table = (DataTable)this.stack.peek();
        int length = attributes.getLength();
        if (table.getColumnCount() == 0) {
            for (int i = 0; i < length; ++i) {
                table.addColumn(attributes.getQName(i));
            }
        }
        DataRecord record = new DataRecord(table);
        for (int i = 0; i < length; ++i) {
            record.set(i, (Object)attributes.getValue(i));
        }
        this.stack.push(record);
    }

    protected void endMessage() {
    }

    protected void endDataTable() {
        DataTable table = (DataTable)this.stack.pop();
        if (!this.stack.isEmpty()) {
            DataRecord record = (DataRecord)this.stack.peek();
            record.addTable(table);
        } else {
            this.message.addTable(table);
        }
    }

    protected void endDataRecord() {
        DataRecord record = (DataRecord)this.stack.pop();
        DataTable table = (DataTable)this.stack.peek();
        table.add(record);
    }
}

