/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.monitor.Kpi;
import com.swimap.base.framework.monitor.KpiManagement;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.Rpc;
import com.swimap.external.dsf.base.rpc.RpcContext;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Rpc(export=true, name="naming.kpi")
public class KpiManagementService {
    private static Log log = LogFactory.getLog(KpiManagementService.class);

    public void start() throws Exception {
        RpcNaming.instance().register(this);
    }

    public void stop() throws Exception {
        RpcNaming.instance().unregister(this);
    }

    @Rpc
    public void test(RpcContext ctx) throws Exception {
        log.info((Object)"demo.test()  called");
    }

    @Rpc(args={"kpis"})
    public void getKPIs(RpcContext ctx, String[] kpis) throws Exception {
        DataTable kpisTable = new DataTable("kpis");
        kpisTable.setColumns("kpi", "value", "type", "description");
        if (kpis.length == 1 && kpis[0].equals("*")) {
            List<Kpi> allKpis = KpiManagement.getInstance().getAllKpi();
            for (Kpi kpi : allKpis) {
                String name = kpi.getName();
                String value = kpi.getKpiValue();
                String type = kpi.getType();
                String description = kpi.getDescription();
                kpisTable.add(new DataRecord(kpisTable, name, value, type, description));
            }
        } else {
            for (int i = 0; i < kpis.length; ++i) {
                String name = kpis[i];
                Kpi kpi = KpiManagement.getInstance().getKpi(name);
                String value = kpi.getKpiValue();
                String type = kpi.getType();
                String description = kpi.getDescription();
                kpisTable.add(new DataRecord(kpisTable, name, value, type, description));
            }
        }
        ctx.returnTable(kpisTable);
    }
}

