/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.IEC;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalErrorUtil {
    public static final String INTERNAL_ERROR_CODE = "com.swimap.base.rpc.internal.error.code";
    public static final String INTERNAL_ERROR_DESC = "com.swimap.base.rpc.internal.error.DESC";
    private static Log log = LogFactory.getLog(InternalErrorUtil.class);

    public static void printInternalError(String moduleName, int errorCode, String errorDesc) {
        log.error((Object)("errorprint: " + moduleName + ": " + errorCode + ", " + errorDesc));
    }

    public static void printInternalError(String moduleName, RpcResponse rsp) {
        int errorCode = rsp.getInternalErrorCode();
        String errorDesc = rsp.getInternalErrorDesc();
        InternalErrorUtil.printInternalError(moduleName, errorCode, errorDesc);
    }

    public static void printInternalError(String moduleName, AppError err) {
        int errorCode = err.getInternalErrorCode();
        String errorDesc = err.getInternalErrorDesc();
        InternalErrorUtil.printInternalError(moduleName, errorCode, errorDesc);
    }

    public static void printInternalError(String moduleName, RpcError err) {
        int errorCode = IEC.getInternalErrorCode(err);
        String errorDesc = IEC.getErrorDesc(errorCode);
        InternalErrorUtil.printInternalError(moduleName, errorCode, errorDesc);
    }
}

