/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.RpcError;
import java.util.HashMap;
import java.util.Map;

public class IEC {
    private static Map<Integer, String> errorMap;

    public static String getErrorDesc(int errorCode) {
        if (IEC.getErrorMap().containsKey(errorCode)) {
            return IEC.getErrorMap().get(errorCode);
        }
        return "";
    }

    public static int getInternalErrorCode(RpcError error) {
        return 0xC000000 + error.getErrorCode();
    }

    private static Map<Integer, String> getErrorMap() {
        if (errorMap == null) {
            errorMap = new HashMap<Integer, String>();
            errorMap.put(201326692, "Rpc unkown error.");
            errorMap.put(201326693, "Rpc socket interrupt.");
            errorMap.put(0xC000066, "Rpc time out.");
            errorMap.put(201326695, "Rpc method not found.");
            errorMap.put(201326696, "Rpc name not found");
            errorMap.put(201326697, "Rpc security error");
            errorMap.put(201326698, "Rpc server busy");
            errorMap.put(201326699, "DS meet max connetions");
            errorMap.put(201326707, "MDP connection interrupt.");
            errorMap.put(0xC000070, "Connect to MDP time out");
            errorMap.put(201326705, "MDP dispatch message failed.");
            errorMap.put(201326706, "MDP Task manager dispatch message failed");
            errorMap.put(201326703, "MDP Other error.");
            errorMap.put(201326708, "MDP Unknown error.");
            errorMap.put(0xC0000BC, "certificate error");
            errorMap.put(201334785, "Failed to get the IP Map from AS.");
            errorMap.put(0xC002002, "MRB address and port is null.");
            errorMap.put(201334787, "AS naming server address is null.");
            errorMap.put(201334788, "EM address is null.");
            errorMap.put(201334789, "Failed to get as OS information.");
            errorMap.put(201334790, "Failed to get HEdex IP&Port.");
            errorMap.put(201334791, "Failed to get AS time zone.");
        }
        return errorMap;
    }

    public static class DSF {
        private static final int OFFSET_DSF = 0xC002000;
        public static final int FAILED_GET_IP_MAP = 201334785;
        public static final int NULL_MRB_ADDR = 0xC002002;
        public static final int NULL_NS_ADDR = 201334787;
        public static final int NULL_EM_ADD = 201334788;
        public static final int FAILED_GET_OS = 201334789;
        public static final int FAILED_GET_HEDEX_ADDR = 201334790;
        public static final int FAILED_GET_TIMEZONE = 201334791;
    }

    public static class RPC {
        private static final int OFFSET_RPC = 0xC000000;
        public static final int RPC_OTHER_ERROR = 201326692;
        public static final int RPC_SOCKET_INTERRUPT = 201326693;
        public static final int RPC_TIME_OUT = 0xC000066;
        public static final int RPC_METHOD_NOT_FOUND = 201326695;
        public static final int RPC_NAME_NOT_FOUND = 201326696;
        public static final int RPC_SECURITY_ERROR = 201326697;
        public static final int RPC_SERVER_BUSY = 201326698;
        public static final int RPC_MET_MAX = 201326699;
        public static final int MDP_CONN_ERROR = 201326707;
        public static final int MDP_TIMEOUT = 0xC000070;
        public static final int MDP_DISP_ERROR = 201326705;
        public static final int MDP_TMGR_DISP_ERROR = 201326706;
        public static final int MDP_OTHER_ERROR = 201326703;
        public static final int MDP_UNKNOW_ERROR = 201326708;
        public static final int CERTIFICATE_ERROR = 0xC0000BC;
    }
}

