/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcServer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Http2HttpsFilter
implements Filter {
    private static Log log = LogFactory.getLog(Http2HttpsFilter.class);
    private final Set<String> redirectURLs = Collections.synchronizedSet(new HashSet());

    public Http2HttpsFilter() {
    }

    public Http2HttpsFilter(Set<String> urls) {
        if (urls != null) {
            for (String url : urls) {
                this.redirectURLs.add(url);
            }
        }
    }

    public void addRedirectURLs(Set<String> urls) {
        if (urls != null) {
            for (String url : urls) {
                this.redirectURLs.add(url);
            }
        }
    }

    public void addRedirectURL(String url) {
        if (url != null) {
            this.redirectURLs.add(url);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest arg1, ServletResponse arg2, FilterChain chain) throws IOException, ServletException {
        try {
            boolean canRedirct;
            HttpServletRequest request = (HttpServletRequest)arg1;
            HttpServletResponse response = (HttpServletResponse)arg2;
            String path = request.getRequestURI();
            if (path != null && (this.redirectURLs.contains(path) || this.redirectURLs.size() == 0) && (canRedirct = RpcServer.redirect2HTTPs(request, response))) {
                return;
            }
        }
        catch (Exception e) {
            log.warn((Object)"doFilter failed in Https");
        }
        chain.doFilter(arg1, arg2);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

