/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.cdr.CdrEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DefaultEventParser
implements RpcEvent.IEventParser {
    private static Log log = LogFactory.getLog(DefaultEventParser.class);

    @Override
    public RpcEvent parse(CdrEvent cdr) {
        RpcEvent event = RpcEvent.create(cdr.getType());
        int count = cdr.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            event.addParameter(cdr.getAttributeName(i), this.extract_value(cdr.getAttribute(i), 0));
        }
        return event;
    }

    Object extract_value(Any any, int level) {
        if (any == null) {
            return null;
        }
        TypeCode tc = any.type();
        Object value = null;
        while (tc.kind() == TCKind.tk_alias) {
            try {
                tc = tc.content_type();
            }
            catch (BadKind e) {
                log.error((Object)"Bad kind :", (Throwable)e);
                return null;
            }
        }
        switch (tc.kind().value()) {
            case 0: {
                value = null;
                break;
            }
            case 2: {
                value = (int)any.extract_short();
                break;
            }
            case 3: {
                value = any.extract_long();
                break;
            }
            case 6: {
                float float_value = any.extract_float();
                value = (double)float_value;
                break;
            }
            case 7: {
                value = any.extract_double();
                break;
            }
            case 8: {
                value = any.extract_boolean();
                break;
            }
            case 18: {
                value = any.extract_string();
                break;
            }
            case 23: {
                value = any.extract_longlong();
                break;
            }
            case 25: {
                value = any.extract_double();
                break;
            }
            case 27: {
                value = any.extract_wstring();
                break;
            }
            case 20: {
                break;
            }
        }
        return value;
    }
}

