/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DataTableHandler
extends DefaultHandler {
    private static final String NAME = "name";
    private static final String RECORD_TAG = "object";
    private static final String TABLE_TAG = "class";
    private Stack<Object> stack = new Stack();
    private DataTable table;

    DataTableHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(TABLE_TAG)) {
            this.startDataTable(attributes);
        } else if (qName.equals(RECORD_TAG)) {
            this.startDataRecord(attributes);
        } else {
            throw new SAXException("Unknown tag: " + qName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(TABLE_TAG)) {
            this.endDataTable();
        } else if (qName.equals(RECORD_TAG)) {
            this.endDataRecord();
        } else {
            throw new SAXException("Unknown tag: " + qName);
        }
    }

    protected void startDataTable(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        DataTable table = new DataTable(attributes.getValue(NAME));
        String name = null;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            name = attributes.getQName(i);
            if (name.equals(NAME)) continue;
            table.addParameter(name, attributes.getValue(i));
        }
        this.stack.push(table);
    }

    protected void startDataRecord(Attributes attributes) {
        DataTable table = (DataTable)this.stack.peek();
        int length = attributes.getLength();
        if (table.getColumnCount() == 0) {
            for (int i = 0; i < length; ++i) {
                table.addColumn(attributes.getQName(i));
            }
        }
        DataRecord record = new DataRecord(table);
        for (int i = 0; i < length; ++i) {
            record.set(i, (Object)attributes.getValue(i));
        }
        this.stack.push(record);
    }

    protected void endDataTable() {
        DataTable table = (DataTable)this.stack.pop();
        if (!this.stack.isEmpty()) {
            DataRecord record = (DataRecord)this.stack.peek();
            record.addTable(table);
        } else {
            this.table = table;
        }
    }

    protected void endDataRecord() {
        DataRecord record = (DataRecord)this.stack.pop();
        DataTable table = (DataTable)this.stack.peek();
        table.add(record);
    }

    DataTable getTable() throws SAXException {
        if (this.table == null) {
            throw new SAXException("Incompleted table");
        }
        return this.table;
    }
}

