/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Compress {
    private static Log log = LogFactory.getLog(Compress.class);
    private static final int BUFFER = 2048;

    public static byte[] compress(byte[] inPutData) {
        Deflater compresser = new Deflater();
        compresser.setInput(inPutData);
        compresser.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inPutData.length);
        byte[] buf = new byte[2048];
        while (!compresser.finished()) {
            int count = compresser.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }

    public static byte[] decompress(byte[] inPutData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(inPutData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inPutData.length);
        byte[] buf = new byte[2048];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                log.error((Object)"", (Throwable)e);
                break;
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        byte[] decompressedData = bos.toByteArray();
        return decompressedData;
    }

    public static byte[] uncompressMsgDate(byte[] data) {
        if (data == null) {
            return null;
        }
        int size = data.length * 20;
        byte[] outDate = null;
        Inflater decompresser = null;
        try {
            while (true) {
                decompresser = new Inflater();
                decompresser.setInput(data);
                outDate = new byte[size];
                int resultLength = decompresser.inflate(outDate);
                boolean finish = decompresser.finished();
                if (finish) {
                    decompresser.end();
                    return outDate;
                }
                size <<= 2;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipCompress(byte[] inPutData) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inPutData);
        GZIPOutputStream zout = null;
        try {
            zout = new GZIPOutputStream(arrayOutputStream);
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                zout.write(buffer, 0, len);
            }
            zout.finish();
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"GZIPOutputStream closing exception.");
            }
            try {
                if (arrayOutputStream != null) {
                    arrayOutputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"ByteArrayOutputStream closing exception.");
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"ByteArrayInputStream closing exception.");
            }
        }
        inPutData = null;
        return arrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipDecompress(byte[] inPutData) {
        GZIPInputStream zin = null;
        try {
            zin = new GZIPInputStream(new ByteArrayInputStream(inPutData));
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        if (zin == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inPutData.length);
        byte[] buf = new byte[2048];
        try {
            int len;
            while ((len = zin.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"GZIPInputStream closing exception.");
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"ByteArrayOutputStream closing exception.");
            }
        }
        inPutData = null;
        return bos.toByteArray();
    }
}

