/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.Framework;
import com.swimap.base.framework.StatusInfoUtil;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CommandProviderNamingEx
implements CommandProvider {
    private String newline = System.getProperty("line.separator");
    private String rt = this.newline + "\t";

    public Object _dsinfo(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "-------Desktop Server Snapshot--------" + this.rt);
        buffer.append("instance name \t\t" + Framework.getInstanceName() + this.rt);
        buffer.append("ds state \t\t" + StatusInfoUtil.getBundlesState() + this.rt);
        buffer.append("config directory \t" + Framework.getConfigDir() + this.rt);
        buffer.append("start time \t\t" + StatusInfoUtil.getStartTime() + " ms" + this.rt);
        buffer.append("running time \t\t" + StatusInfoUtil.getRunTime() + " ms" + this.rt);
        buffer.append("heap memory used \t" + StatusInfoUtil.getHeapMemoryUsageUsed() + " bytes" + this.rt);
        buffer.append("number of live threads \t" + StatusInfoUtil.getThreadCount() + this.rt);
        buffer.append("install bundles :" + this.rt);
        for (String bundle : StatusInfoUtil.getBundleNames()) {
            buffer.append("\t" + bundle + this.rt);
        }
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumpConnections(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "-------Desktop Server TCP Connection Information--------" + this.rt);
        SocketConnection[] connections = Clients.getSocketConnections();
        for (int i = 0; i < connections.length; ++i) {
            SocketConnection connector = connections[i];
            buffer.append(connector.getRemoteAddress()).append(":").append(connector.getRemotePort());
            if (connector.isSSLConnection()) {
                buffer.append("\t").append("TCPS");
            } else {
                buffer.append("\t").append("TCP");
            }
            buffer.append("\t").append(connector.getClientID() + this.rt);
        }
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumprpc(CommandInterpreter intp) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RpcRegister.instance().dump(out);
        intp.print((Object)out.toString());
        return null;
    }

    public Object _dumpevent(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        Map<EventClassType, Set<String>> subscribers = RpcUtil.getSubscribers();
        for (Map.Entry<EventClassType, Set<String>> entry : subscribers.entrySet()) {
            buffer.append(entry.getKey() + this.rt);
            for (String sub : entry.getValue()) {
                buffer.append(sub + ";");
                ++count;
            }
            buffer.append(this.newline);
        }
        buffer.append("total subscribers: " + count + this.rt);
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumpThreadPoolInfo(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        int min = 0;
        int max = 0;
        int size = 0;
        ThreadPoolManager manager = ThreadPoolManager.getInstance();
        ThreadPoolExecutor threadPool = manager.getReadThreadPool();
        min = threadPool.getCorePoolSize();
        max = threadPool.getMaximumPoolSize();
        size = threadPool.getQueue().size();
        buffer.append(this.rt);
        buffer.append("read thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        QueuedThreadPool queuePool = manager.getWriteThreadPool();
        min = queuePool.getMinThreads();
        max = queuePool.getMaxThreads();
        size = queuePool.getQueueSize();
        buffer.append("write thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        queuePool = manager.getTaskThreadPool();
        min = queuePool.getMinThreads();
        max = queuePool.getMaxThreads();
        size = queuePool.getQueueSize();
        buffer.append("task thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        threadPool = manager.getEventThreadPool();
        min = threadPool.getCorePoolSize();
        max = threadPool.getMaximumPoolSize();
        size = threadPool.getQueue().size();
        buffer.append("event thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        intp.print((Object)buffer.toString());
        return null;
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "------ Desktop Server extended Commamd ------" + this.rt);
        buffer.append(this.rt);
        buffer.append("dsinfo - query ds iner status" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumprpc - dump all registered rpc methods" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpevent - dump all subscribed CDR event" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpThreadPoolInfo - dump all thread pool info" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpConnections - dump all tcp connection info" + this.rt);
        buffer.append(this.rt);
        String info = buffer.toString();
        return info;
    }
}

