/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.Framework;
import com.swimap.base.framework.StatusInfoUtil;
import com.swimap.base.rpc.RpcEMHandler;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.nio.Clients;
import com.swimap.base.rpc.nio.QueuedThreadPool;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import com.swimap.external.dsf.base.rpc.em.EventClassType;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CommandProviderEx
implements CommandProvider {
    private String newline = System.getProperty("line.separator");
    private String rt = this.newline + "\t";

    public Object _settrace(CommandInterpreter intp) {
        String level = intp.nextArgument();
        if (level == null) {
            intp.println((Object)this.getHelp());
        } else {
            Logger logger = LogManager.getRootLogger();
            if ("debug".equalsIgnoreCase(level)) {
                logger.setLevel(Level.DEBUG);
            } else if ("info".equalsIgnoreCase(level)) {
                logger.setLevel(Level.INFO);
            } else if ("warn".equalsIgnoreCase(level)) {
                logger.setLevel(Level.WARN);
            } else if ("error".equalsIgnoreCase(level)) {
                logger.setLevel(Level.ERROR);
            } else if ("fatal".equalsIgnoreCase(level)) {
                logger.setLevel(Level.FATAL);
            } else if ("trace".equalsIgnoreCase(level)) {
                logger.setLevel(Level.TRACE);
            } else if ("all".equalsIgnoreCase(level)) {
                logger.setLevel(Level.ALL);
            } else if ("off".equalsIgnoreCase(level)) {
                logger.setLevel(Level.OFF);
            } else {
                intp.println((Object)("Current Log Level : " + logger.getLevel().toString() + "\n\t"));
                intp.println((Object)this.getHelp());
            }
        }
        return null;
    }

    public Object _dsinfo(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "-------Desktop Server Snapshot--------" + this.rt);
        buffer.append("instance name \t\t" + Framework.getInstanceName() + this.rt);
        buffer.append("ds state \t\t" + StatusInfoUtil.getBundlesState() + this.rt);
        buffer.append("config directory \t" + Framework.getConfigDir() + this.rt);
        buffer.append("start time \t\t" + StatusInfoUtil.getStartTime() + " ms" + this.rt);
        buffer.append("running time \t\t" + StatusInfoUtil.getRunTime() + " ms" + this.rt);
        buffer.append("heap memory used \t" + StatusInfoUtil.getHeapMemoryUsageUsed() + " bytes" + this.rt);
        buffer.append("number of live threads \t" + StatusInfoUtil.getThreadCount() + this.rt);
        buffer.append("install bundles :" + this.rt);
        for (String bundle : StatusInfoUtil.getBundleNames()) {
            buffer.append("\t" + bundle + this.rt);
        }
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumpConnections(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "-------Desktop Server TCP Connection Information--------" + this.rt);
        SocketConnection[] connections = Clients.getSocketConnections();
        for (int i = 0; i < connections.length; ++i) {
            SocketConnection connector = connections[i];
            buffer.append(connector.getRemoteAddress()).append(":").append(connector.getRemotePort());
            if (connector.isSSLConnection()) {
                buffer.append("\t").append("TCPS");
            } else {
                buffer.append("\t").append("TCP");
            }
            buffer.append("\t").append(connector.getClientID() + this.rt);
        }
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumprpc(CommandInterpreter intp) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RpcRegister.instance().dump(out);
        intp.print((Object)out.toString());
        return null;
    }

    public Object _dumpevent(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        Map<EventClassType, Set<String>> subscribers = RpcEMHandler.instance.GetSubscribers();
        for (Map.Entry<EventClassType, Set<String>> entry : subscribers.entrySet()) {
            buffer.append(entry.getKey() + this.rt);
            for (String sub : entry.getValue()) {
                buffer.append(sub + ";");
                ++count;
            }
            buffer.append(this.newline);
        }
        buffer.append("total subscribers: " + count + this.rt);
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _dumpThreadPoolInfo(CommandInterpreter intp) {
        StringBuffer buffer = new StringBuffer();
        int min = 0;
        int max = 0;
        int size = 0;
        ThreadPoolManager manager = ThreadPoolManager.getInstance();
        ThreadPoolExecutor threadPool = manager.getReadThreadPool();
        min = threadPool.getCorePoolSize();
        max = threadPool.getMaximumPoolSize();
        size = threadPool.getQueue().size();
        buffer.append(this.rt);
        buffer.append("read thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        QueuedThreadPool queuePool = manager.getWriteThreadPool();
        min = queuePool.getMinThreads();
        max = queuePool.getMaxThreads();
        size = queuePool.getQueueSize();
        buffer.append("write thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        queuePool = manager.getTaskThreadPool();
        min = queuePool.getMinThreads();
        max = queuePool.getMaxThreads();
        size = queuePool.getQueueSize();
        buffer.append("task thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        threadPool = manager.getEventThreadPool();
        min = threadPool.getCorePoolSize();
        max = threadPool.getMaximumPoolSize();
        size = threadPool.getQueue().size();
        buffer.append("event thread pool minThreads=" + min + " maxThreads=" + max + " queueSize=" + size + this.rt);
        intp.print((Object)buffer.toString());
        return null;
    }

    public Object _setMaxReadPoolSize(CommandInterpreter intp) {
        int maxThreads;
        String max = intp.nextArgument();
        try {
            maxThreads = Integer.valueOf(max);
        }
        catch (Exception e) {
            intp.println((Object)this.getHelp());
            return null;
        }
        ThreadPoolExecutor threadPool = ThreadPoolManager.getInstance().getReadThreadPool();
        if (maxThreads < threadPool.getCorePoolSize()) {
            intp.println((Object)("failed : maxThreads " + maxThreads + " is less than minThreads" + threadPool.getCorePoolSize()));
        } else {
            threadPool.setMaximumPoolSize(maxThreads);
            intp.print((Object)("success : set read thread pool maxThreads = " + maxThreads));
        }
        return null;
    }

    public Object _setMaxTaskPoolSize(CommandInterpreter intp) {
        int maxThreads;
        String max = intp.nextArgument();
        try {
            maxThreads = Integer.valueOf(max);
        }
        catch (Exception e) {
            intp.println((Object)this.getHelp());
            return null;
        }
        QueuedThreadPool threadPool = ThreadPoolManager.getInstance().getTaskThreadPool();
        if (maxThreads < threadPool.getMaxThreads()) {
            intp.println((Object)("failed : maxThreads " + maxThreads + " is less than minThreads" + threadPool.getMinThreads()));
        } else {
            threadPool.setMaxThreads(maxThreads);
            intp.print((Object)("success : set task thread pool maxThreads = " + maxThreads));
        }
        return null;
    }

    public Object _setMaxWritePoolSize(CommandInterpreter intp) {
        int maxThreads;
        String max = intp.nextArgument();
        try {
            maxThreads = Integer.valueOf(max);
        }
        catch (Exception e) {
            intp.println((Object)this.getHelp());
            return null;
        }
        QueuedThreadPool threadPool = ThreadPoolManager.getInstance().getWriteThreadPool();
        if (maxThreads < threadPool.getMaxThreads()) {
            intp.println((Object)("failed : maxThreads " + maxThreads + " is less than minThreads" + threadPool.getMinThreads()));
        } else {
            threadPool.setMaxThreads(maxThreads);
            intp.print((Object)("success : set write thread pool maxThreads = " + maxThreads));
        }
        return null;
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.newline + "------ Desktop Server extended Commamd ------" + this.rt);
        buffer.append("settrace <level> - specified the log level" + this.rt);
        buffer.append("level : < fatal | error | warn | info | debug | trace | off >" + this.rt);
        buffer.append(this.rt);
        buffer.append("setMaxReadPoolSize - set max read thread pool size" + this.rt);
        buffer.append(this.rt);
        buffer.append("setMaxWritePoolSize - set max write thread pool size" + this.rt);
        buffer.append(this.rt);
        buffer.append("setMaxTaskPoolSize - set max rpc task thread pool size" + this.rt);
        buffer.append(this.rt);
        buffer.append("dsinfo - query ds iner status" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumprpc - dump all registered rpc methods" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpevent - dump all subscribed CDR event" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpThreadPoolInfo - dump all thread pool info" + this.rt);
        buffer.append(this.rt);
        buffer.append("dumpConnections - dump all tcp connection info" + this.rt);
        buffer.append(this.rt);
        String info = buffer.toString();
        return info;
    }
}

