/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.BinHelper;
import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.nio.ISocketPDU;
import com.swimap.base.rpc.nio.SocketConnection;
import com.swimap.base.rpc.nio.SocketHandler;
import com.swimap.base.rpc.nio.ThreadPoolManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BinTranslator {
    private static Log log = LogFactory.getLog(BinTranslator.class);
    static final String PATH_CHARSET = "UTF-8";
    static final int MAX_PATH_LENGTH = 1024;
    private static final long MAX_PDU_SIZE = 0x200000L;

    public static byte[] transPDU(RpcSocketPDU socketPDU, boolean isUseOldProtocal) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinTranslator.writeToStream(socketPDU, baos, isUseOldProtocal);
        return baos.toByteArray();
    }

    public static void writeToStream(RpcSocketPDU socketPDU, OutputStream out, boolean isUseOldProtocal) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeByte(socketPDU.getType());
        String path = socketPDU.getPath();
        byte[] buf = path == null ? new byte[]{} : path.getBytes(PATH_CHARSET);
        dos.writeInt(buf.length);
        dos.write(buf);
        BinHelper helper = new BinHelper();
        int contentLength = 0;
        if (isUseOldProtocal) {
            helper.doWrite(dos, socketPDU.getMessage());
            contentLength = dos.size();
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos_tmp = new DataOutputStream(bos);
            helper.doWrite(dos_tmp, socketPDU.getMessage());
            contentLength = dos_tmp.size();
            dos.writeInt(contentLength);
            bos.writeTo(dos);
        }
        if ((long)contentLength > 0x200000L) {
            log.error((Object)String.format("there is a very big pdu, size=%s, path=%s", contentLength, socketPDU.getPath()));
        }
    }

    public static List<ISocketPDU> readBytes2PDUList(SocketConnection conn, byte[] bytes) throws Exception {
        Vector<ISocketPDU> list = new Vector<ISocketPDU>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        RpcSocketPDU pdu = null;
        while ((pdu = BinTranslator.readPDU(conn, inputStream)) != null) {
            list.add(pdu);
        }
        return list;
    }

    static RpcSocketPDU readPDU(SocketConnection connection, InputStream inputStream) throws Exception {
        if (BinTranslator.isInputStreamOver(inputStream)) {
            return null;
        }
        RpcSocketPDU pdu = new RpcSocketPDU();
        DataInputStream input = new DataInputStream(inputStream);
        pdu.setType(input.readByte());
        int len = input.readInt();
        if (len > 1024) {
            throw new IOException("Invalid protocol, path too long.");
        }
        byte[] buffer = new byte[len];
        input.readFully(buffer, 0, len);
        pdu.setPath(new String(buffer, 0, len, PATH_CHARSET));
        if (!connection.isUseOldProtocal()) {
            int contentLength = input.readInt();
            if (log.isInfoEnabled()) {
                log.info((Object)("pdu content length :" + contentLength));
            }
            if (connection.isRpcServerSide() && contentLength > RpcUtil.MAX_CONTENT_LEN) {
                throw new IOException("pdu's content out of length. " + contentLength);
            }
        }
        BinHelper helper = new BinHelper();
        pdu.setMessage(helper.doParse(input));
        pdu.setCancelTime();
        if (5 == pdu.getType()) {
            connection.updateLastReadTime();
            pdu.setType((byte)2);
            log.info((Object)("begin response heart beat from " + connection + " in message id" + pdu.getId()));
            connection.writePDU(pdu);
            log.info((Object)("response heart beat successful from " + connection + " in message id" + pdu.getId()));
            return null;
        }
        if (6 == pdu.getType()) {
            List<Runnable> queue = ThreadPoolManager.getInstance().getTaskThreadPool().getQueue();
            return BinTranslator.removeCancelPduHandler(pdu, queue);
        }
        return pdu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RpcSocketPDU removeCancelPduHandler(RpcSocketPDU pdu, List<Runnable> queue) {
        Runnable[] array = null;
        List<Runnable> list = queue;
        synchronized (list) {
            if (queue.size() <= 0) {
                return null;
            }
            array = new Runnable[queue.size()];
            queue.toArray(array);
        }
        for (Runnable runnable : array) {
            if (!(runnable instanceof SocketHandler)) continue;
            SocketHandler r = (SocketHandler)runnable;
            int id = r.getSocketPDU().getId();
            if (pdu.getMessage().getMessageId() != id) continue;
            List<Runnable> list2 = queue;
            synchronized (list2) {
                if (queue.remove(r)) {
                    // empty if block
                }
            }
        }
        return null;
    }

    private static boolean isInputStreamOver(InputStream inputStream) throws Exception {
        try {
            if (inputStream instanceof ByteArrayInputStream && inputStream.available() <= 0) {
                return true;
            }
        }
        catch (Exception e) {
            if (!(inputStream instanceof ByteArrayInputStream)) {
                throw e;
            }
            return true;
        }
        return false;
    }
}

