/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.rpc.RpcSocketPDU;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.Token;
import com.swimap.base.rpc.nio.SocketClientConnector;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcParameter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BinHelper {
    private static final byte MSG_TYPE_REQUEST = 1;
    private static final byte MSG_TYPE_RESPONSE = 2;
    private static final byte MSG_TYPE_EVENT = 3;
    private static final byte MSG_TYPE_EXCEPTION = 4;
    private static final byte MSG_TYPE_UNKNOWN = -1;
    private static final byte TAG_MSG_END = 0;
    private static final byte TAG_PARAS_START = 16;
    private static final byte TAG_PARAS_END = 17;
    private static final byte TAG_TABLE_NAME = 32;
    private static final byte TAG_COLUMNS_START = 48;
    private static final byte TAG_COLUMNS_END = 49;
    private static final byte TAG_RECORD = 64;
    private static final byte TAG_NESTED_START = 65;
    private static final byte TAG_NESTED_END = 66;
    private static final byte TAG_STRING_1B = 81;
    private static final byte TAG_STRING_2B = 82;
    private static final byte TAG_STRING_4B = 84;
    private static final byte TAG_ATTACH = 10;
    private static Log log = LogFactory.getLog(BinHelper.class);
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private DataOutputStream dout = new DataOutputStream(this.bout);
    private byte[] rbuf = new byte[2048];
    private char[] decoderArray = new char[2048];
    private int decodePos;

    private int encodeUTF8(String str) {
        byte[] bytebuf;
        if (str == null) {
            return 0;
        }
        int strlen = str.length();
        if (strlen * 3 > (bytebuf = this.rbuf).length) {
            bytebuf = this.rbuf = new byte[strlen * 3];
        }
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytebuf[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytebuf[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytebuf[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytebuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytebuf[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytebuf[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return count;
    }

    private String decodeUTF8(byte[] bytes, int offset, int length) throws IOException {
        char[] cdata = this.decoderArray;
        if (cdata.length < length) {
            cdata = this.decoderArray = new char[length];
        }
        int in = offset;
        int out = 0;
        int end = length + offset;
        try {
            int ch = 0;
            while (in < end) {
                if ((ch = bytes[in++] & 0xFF) >= 128) {
                    if (ch < 224) {
                        ch = (ch & 0x1F) << 6;
                        ch |= bytes[in++] & 0x3F;
                    } else {
                        ch = (ch & 0xF) << 12;
                        ch |= (bytes[in++] & 0x3F) << 6;
                        ch |= bytes[in++] & 0x3F;
                    }
                }
                cdata[out++] = (char)ch;
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw new IOException("UTF-8 string representation was truncated");
        }
        if (in > end) {
            throw new IOException("UTF-8 string representation was truncated");
        }
        return new String(cdata, 0, out).intern();
    }

    private String decodeNullEndUTF8(byte[] bytes) throws IOException {
        char[] cdata = this.decoderArray;
        int in = this.decodePos;
        int out = 0;
        int ch = 0;
        try {
            while ((ch = bytes[in++] & 0xFF) != 0) {
                if (ch >= 128) {
                    if (ch < 224) {
                        ch = (ch & 0x1F) << 6;
                        ch |= bytes[in++] & 0x3F;
                    } else {
                        ch = (ch & 0xF) << 12;
                        ch |= (bytes[in++] & 0x3F) << 6;
                        ch |= bytes[in++] & 0x3F;
                    }
                }
                if (out == cdata.length) {
                    char[] newbuf = new char[out * 2];
                    System.arraycopy(cdata, 0, newbuf, 0, out);
                    this.decoderArray = newbuf;
                    cdata = newbuf;
                }
                cdata[out++] = (char)ch;
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw new IOException("UTF-8 string representation was truncated");
        }
        this.decodePos = in;
        return new String(cdata, 0, out).intern();
    }

    private void writeRecord(DataOutputStream out, DataRecord record) throws IOException {
        this.bout.reset();
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            int len = this.encodeUTF8(record.get(i));
            this.dout.write(this.rbuf, 0, len);
            this.dout.write(0);
        }
        out.writeInt(this.bout.size());
        this.bout.writeTo(out);
        if (record.hasTable()) {
            out.writeByte(65);
            Collection<DataTable> tables = record.getTables().values();
            for (DataTable table : tables) {
                this.writeTable(out, table);
            }
            out.writeByte(66);
        }
    }

    private void readRecord(DataInputStream in, DataRecord record) throws Exception {
        int len = in.readInt();
        if (len > RpcUtil.MAX_RECORD_SIZE) {
            log.error((Object)("record out of size, len: " + len));
            throw new IOException("record out of size");
        }
        byte[] readbuf = this.rbuf;
        if (len > readbuf.length) {
            readbuf = this.rbuf = new byte[len];
        }
        in.readFully(readbuf, 0, len);
        this.decodePos = 0;
        int recordCount = record.size();
        for (int i = 0; i < recordCount; ++i) {
            record.setValue(i, this.decodeNullEndUTF8(readbuf));
        }
    }

    private void getNextToken(DataInputStream is, Token token) throws Exception {
        token.tag = is.readByte();
        int len = 0;
        if (token.tag == 81) {
            len = is.readUnsignedByte();
        } else if (token.tag == 82) {
            len = is.readUnsignedShort();
        } else if (token.tag == 84) {
            len = is.readInt();
        } else {
            return;
        }
        if (len > RpcUtil.MAX_TOKEN_SIZE) {
            log.error((Object)("token out of size, len: " + len));
            throw new IOException("token out of size.");
        }
        if (len > this.rbuf.length) {
            this.rbuf = new byte[len];
        }
        is.readFully(this.rbuf, 0, len);
        token.value = this.decodeUTF8(this.rbuf, 0, len);
    }

    private void writeString(DataOutputStream os, String str) throws IOException {
        int len = this.encodeUTF8(str);
        if (len < 256) {
            os.write(81);
            os.writeByte(len);
        } else if (len < 65536) {
            os.write(82);
            os.writeShort(len);
        } else {
            os.write(84);
            os.writeInt(len);
        }
        os.write(this.rbuf, 0, len);
    }

    private void writeRpcMesage(OutputStream out, RpcMessage message) throws IOException {
        DataOutputStream os = new DataOutputStream(out);
        this.doWrite(os, message);
    }

    public static int getPDUSize(RpcSocketPDU pdu) {
        int result = 5;
        result += pdu.getPath().getBytes().length;
        return result += BinHelper.getRpcMessageSize(pdu.getMessage());
    }

    private static int getRpcMessageSize(RpcMessage message) {
        int result = 4;
        if (message.hasMessageId()) {
            result += "_mid".getBytes().length;
            result += String.valueOf(message.getMessageId()).getBytes().length;
        }
        if (message.hasSessionId()) {
            result += "_sid".getBytes().length;
            result += message.getSessionId().getBytes().length;
        }
        Collection<RpcParameter> paras = message.getParameters();
        for (RpcParameter rpcParameter : paras) {
            result += rpcParameter.getName().getBytes().length;
            result += rpcParameter.getValue().getBytes().length;
        }
        for (DataTable dataTable : message.tables()) {
            result += BinHelper.getTableSize(dataTable);
        }
        if (message.hasAttachments()) {
            for (Map.Entry entry : message.getAttachments().entrySet()) {
                ++result;
                result += 4;
                result += ((String)entry.getKey()).getBytes().length;
                result += ((byte[])entry.getValue()).length;
            }
        }
        return result;
    }

    private static int getTableSize(DataTable table) {
        int result = 3;
        result += table.getName().getBytes().length;
        if (table.hasParameter()) {
            ++result;
            Collection<RpcParameter> paras = table.getParameters();
            for (RpcParameter para : paras) {
                result += para.getName().getBytes().length;
                result += para.getValue().getBytes().length;
            }
            ++result;
        }
        int cloumnCount = table.getColumnCount();
        for (int i = 0; i < cloumnCount; ++i) {
            result += table.getColumnName(i).getBytes().length;
        }
        for (DataRecord record : table) {
            ++result;
            result += BinHelper.getRecordSize(record);
        }
        return result;
    }

    private static int getRecordSize(DataRecord record) {
        int result = 4;
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            result += record.get(i).getBytes().length;
            result += 4;
        }
        if (record.hasTable()) {
            ++result;
            Collection<DataTable> tables = record.getTables().values();
            for (DataTable table : tables) {
                result += BinHelper.getTableSize(table);
            }
            ++result;
        }
        return result;
    }

    final void doWrite(DataOutputStream os, RpcMessage message) throws IOException {
        os.writeByte(BinHelper.getMessageTypeId(message.getType()));
        os.writeByte(16);
        if (message.hasMessageId()) {
            this.writeString(os, "_mid");
            this.writeString(os, String.valueOf(message.getMessageId()));
        }
        if (message.hasSessionId()) {
            this.writeString(os, "_sid");
            this.writeString(os, message.getSessionId());
        }
        Collection<RpcParameter> paras = message.getParameters();
        for (RpcParameter rpcParameter : paras) {
            this.writeString(os, rpcParameter.getName());
            this.writeString(os, rpcParameter.getValue());
        }
        os.writeByte(17);
        for (DataTable dataTable : message.tables()) {
            this.writeTable(os, dataTable);
        }
        if (message.hasAttachments()) {
            for (Map.Entry entry : message.getAttachments().entrySet()) {
                os.writeByte(10);
                this.writeString(os, (String)entry.getKey());
                os.writeInt(((byte[])entry.getValue()).length);
                os.write((byte[])entry.getValue());
            }
        }
        os.writeByte(0);
    }

    private void writeTable(DataOutputStream os, DataTable table) throws IOException {
        os.writeByte(32);
        this.writeString(os, table.getName());
        if (table.hasParameter()) {
            os.writeByte(16);
            Collection<RpcParameter> paras = table.getParameters();
            for (RpcParameter para : paras) {
                this.writeString(os, para.getName());
                this.writeString(os, para.getValue());
            }
            os.writeByte(17);
        }
        os.writeByte(48);
        int cloumnCount = table.getColumnCount();
        for (int i = 0; i < cloumnCount; ++i) {
            this.writeString(os, table.getColumnName(i));
        }
        os.writeByte(49);
        for (DataRecord record : table) {
            os.writeByte(64);
            this.writeRecord(os, record);
        }
    }

    final RpcMessage doParse(DataInputStream is) throws Exception {
        Token token = new Token();
        RpcMessage message = new RpcMessage();
        byte type = is.readByte();
        message.setType(BinHelper.getMessageType(type));
        this.getNextToken(is, token);
        if (token.tag == 16) {
            this.getNextToken(is, token);
            String name = null;
            String value = null;
            while (token.tag != 17) {
                name = token.value;
                this.getNextToken(is, token);
                value = token.value;
                if (!message.setInternalParameter(name, value)) {
                    message.addParameter(name, value);
                }
                this.getNextToken(is, token);
            }
            this.getNextToken(is, token);
        }
        DataTable table = null;
        while (token.tag == 32) {
            table = this.readTable(is, token);
            message.addTable(table);
        }
        int len = 0;
        while (token.tag == 10) {
            this.getNextToken(is, token);
            len = is.readInt();
            if (len > RpcUtil.MAX_ATTACH_SIZE && !SocketClientConnector.isRpcSocketClient()) {
                log.error((Object)("attach out of size, len: " + len));
                throw new IOException("attach out of size");
            }
            byte[] data = new byte[len];
            is.readFully(data);
            message.addAttachment(token.value, data);
            this.getNextToken(is, token);
        }
        return message;
    }

    private DataTable readTable(DataInputStream is, Token token) throws Exception {
        this.getNextToken(is, token);
        DataTable table = new DataTable(token.value);
        this.getNextToken(is, token);
        if (token.tag == 16) {
            this.getNextToken(is, token);
            String paraName = null;
            while (token.tag != 17) {
                paraName = token.value;
                this.getNextToken(is, token);
                table.addParameter(paraName, token.value);
                this.getNextToken(is, token);
            }
            this.getNextToken(is, token);
        }
        if (token.tag == 48) {
            this.getNextToken(is, token);
            while (token.tag != 49) {
                table.addColumn(token.value);
                this.getNextToken(is, token);
            }
        }
        this.getNextToken(is, token);
        DataRecord record = null;
        while (token.tag == 64) {
            record = new DataRecord(table);
            this.readRecord(is, record);
            this.getNextToken(is, token);
            if (token.tag == 65) {
                this.getNextToken(is, token);
                while (token.tag == 32) {
                    record.addTable(this.readTable(is, token));
                }
                this.getNextToken(is, token);
            }
            table.add(record);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcMessage parseRpcMessage(InputStream input) {
        try {
            DataInputStream is = new DataInputStream(input);
            RpcMessage rpcMessage = this.doParse(is);
            return rpcMessage;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            RpcMessage rpcMessage = new RpcMessage();
            return rpcMessage;
        }
        finally {
            try {
                byte[] buf = new byte[1024];
                while (input.read(buf) >= 0) {
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    private static String getMessageType(byte type) {
        switch (type) {
            case 1: {
                return "request";
            }
            case 2: {
                return "response";
            }
            case 3: {
                return "event";
            }
            case 4: {
                return "exception";
            }
        }
        return "unknown";
    }

    private static byte getMessageTypeId(String type) {
        if (type.equals("request")) {
            return 1;
        }
        if (type.equals("response")) {
            return 2;
        }
        if (type.equals("event")) {
            return 3;
        }
        if (type.equals("exception")) {
            return 4;
        }
        return -1;
    }

    public static final RpcMessage parseMessage(InputStream input) {
        BinHelper helper = new BinHelper();
        return helper.parseRpcMessage(input);
    }

    public static final void writeMessage(OutputStream out, RpcMessage message) throws IOException {
        BinHelper helper = new BinHelper();
        helper.writeRpcMesage(out, message);
    }
}

