/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressInfo {
    private static Log log = LogFactory.getLog(AddressInfo.class);
    private static String orbNsURL = System.getProperty("imap.rpc.orb.ns");
    private static String emURL = System.getProperty("imap.rpc.em");
    private static String mrbURL = System.getProperty("imap.rpc.mdp");
    private static String emURLs = System.getProperty("imap.url.em");
    private static String mrbURLs = System.getProperty("imap.url.mrb");
    private static String orbNsURLs = System.getProperty("imap.url.orb");

    public AddressInfo() {
        orbNsURL = System.getProperty("imap.rpc.orb.ns");
        emURL = System.getProperty("imap.rpc.em");
        mrbURL = System.getProperty("imap.rpc.mdp");
        emURLs = System.getProperty("imap.url.em");
        mrbURLs = System.getProperty("imap.url.mrb");
        orbNsURLs = System.getProperty("imap.url.orb");
    }

    public static URI getEventManagrURI() {
        URI uri = null;
        if (emURL == null) {
            return null;
        }
        try {
            uri = new URI(emURL);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid em URL:" + emURL));
        }
        return uri;
    }

    public static URI getAsNamingServerURI() {
        URI uri = null;
        if (orbNsURL == null) {
            return null;
        }
        String url = orbNsURL.replaceFirst("corbaloc:iiop:", "iiop://");
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid orbNs URL:" + url));
        }
        return uri;
    }

    public static URI getMdpURI() {
        URI uri = null;
        if (mrbURL == null) {
            return null;
        }
        try {
            uri = new URI(mrbURL);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid mdp URL:" + mrbURL));
        }
        return uri;
    }

    public static String getEmURLs() {
        return emURLs;
    }

    public static String getMdpURLs() {
        return mrbURLs;
    }

    public static String getOrbURLs() {
        return orbNsURLs;
    }
}

