/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.rpc;

import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.rpc.CommandProviderEx;
import com.swimap.base.rpc.NATUtilService;
import com.swimap.base.rpc.RpcRegister;
import com.swimap.base.rpc.RpcServer;
import com.swimap.base.rpc.RpcUtil;
import com.swimap.base.rpc.StartListener;
import com.swimap.base.rpc.nio.ThreadPoolWatchdog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;

public class Activator
implements BundleActivator {
    private static Log log = LogFactory.getLog(Activator.class);
    public static final String moduleName = "DSF";
    private ThreadPoolWatchdog threadDog;
    public static final String FrameParameter_ListeningPorts = "Listening Ports";
    public static final String FrameParameter_MaxClientCount = "MaxClientCount";
    public static final String FrameParameter_SSL_HTTP = "HTTP SSL";
    public static final String FrameParameter_SSL_TCP = "TCP SSL";

    public void start(BundleContext context) throws Exception {
        StartListener listener = new StartListener();
        context.addServiceListener((ServiceListener)listener, "(objectClass=com.swimap.base.framework.Framework)");
        context.registerService(CommandProvider.class.getName(), (Object)new CommandProviderEx(), null);
        if ("true".equals(System.getProperty("imap.framework.autoupdate"))) {
            context.addFrameworkListener((FrameworkListener)listener);
        }
        RpcServer.getInstance().doStart();
        if (System.getProperty("enableThreadPoolWatchdog") == null || Boolean.getBoolean("enableThreadPoolWatchdog")) {
            this.threadDog = new ThreadPoolWatchdog();
            this.threadDog.start();
        }
        FrameInformationManager.getInstance().record(FrameParameter_MaxClientCount, RpcUtil.getMaxClientCount());
        log.warn((Object)"RPC Server started!");
    }

    public void stop(BundleContext context) throws Exception {
        RpcRegister.remove(NATUtilService.class);
        RpcServer.getInstance().doStop();
        if (this.threadDog != null) {
            this.threadDog.stop();
        }
        log.warn((Object)"RPC Server stopped!");
    }
}

