/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.watchdog;

import com.sun.management.OperatingSystemMXBean;
import com.swimap.base.framework.FrameInformationManager;
import com.swimap.base.framework.StopDsThread;
import com.swimap.base.framework.monitor.CleanManagement;
import com.swimap.base.framework.monitor.ThreadCheckManager;
import com.swimap.base.framework.monitor.ThreadChecker;
import com.swimap.base.framework.watchdog.Config;
import com.swimap.base.framework.watchdog.MXBeanCheck;
import com.swimap.base.framework.watchdog.ThreadData;
import com.swimap.base.framework.watchdog.Util;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WatchDog
implements Runnable {
    private boolean running;
    private Thread thread;
    private static Log log = LogFactory.getLog(WatchDog.class);
    private Map<Long, ThreadData> lastLockMap;
    private Config config;
    public static final int NOT_NEED_STOP = 0;
    public static final int STOP_FOR_POOL_BLOCK = 1;
    public static final int STOP_FOR_SIXTY_BLOCK = 2;
    public static final int STOP_FOR_THIRTY_BLOCK = 3;
    public static final int STOP_FOR_THREAD_CHECK_FAILED = 4;
    private static final long PRINTVM_INTERVAL = 300000L;
    private static long lastPrintVMTime;
    private Map<String, MXBeanCheck> mxBeanCheckMap = null;
    private static final String MEMORY_OLD_USED_PERCENT = "memory.old.used.percent";
    private static long prevProcessCpuTime;
    private static long prevUpTime;
    Map<ThreadChecker, Integer> failedCheckThreadMap = new HashMap<ThreadChecker, Integer>();

    public WatchDog() {
        this.config = new Config();
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.thread = new Thread((Runnable)this, "WatchDog");
            this.thread.setPriority(10);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.running && this.thread != null) {
            this.running = false;
            this.thread.interrupt();
            this.thread = null;
            log.warn((Object)"WatchDog Stopped!");
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.runWatchDog();
            }
            catch (Exception t) {
                log.error((Object)"run failed", (Throwable)t);
                continue;
            }
            break;
        }
    }

    private void runWatchDog() {
        if (!this.config.isWatchdogEnable()) {
            return;
        }
        log.warn((Object)"WatchDog Started!");
        ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
        tmx.setThreadContentionMonitoringEnabled(true);
        while (this.running) {
            try {
                Thread.sleep(this.config.getCheckInterval());
                this.doCheck(tmx);
                WatchDog.printVMInfo();
            }
            catch (Exception e) {
                if (this.running) continue;
                break;
            }
        }
    }

    private static boolean needPrintVMInfo() {
        long currentPrintVMTime = System.currentTimeMillis();
        if (currentPrintVMTime - lastPrintVMTime > 300000L) {
            lastPrintVMTime = currentPrintVMTime;
            return true;
        }
        return false;
    }

    private static void printVMInfo() {
        try {
            if (WatchDog.needPrintVMInfo()) {
                String cpuInfo = WatchDog.getCPUInfo();
                String heapInfo = WatchDog.getHeapInfo();
                String threadInfo = WatchDog.getThreadInfo();
                log.warn((Object)("Monitor:" + cpuInfo + heapInfo + threadInfo));
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private static String getThreadInfo() {
        return String.format("[ThreadInfo]:%s;", ManagementFactory.getThreadMXBean().getThreadCount());
    }

    private static String getHeapInfo() {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long init = memoryUsage.getInit();
        long used = memoryUsage.getUsed();
        long max = memoryUsage.getMax();
        return String.format("[heap(init/used/max)(M)]:%s/%s/%s", init, used, max);
    }

    private static String getCPUInfo() {
        OperatingSystemMXBean mxbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long processCpuTime = mxbean.getProcessCpuTime();
        long upTime = ManagementFactory.getRuntimeMXBean().getUptime();
        long elapsedCpu = processCpuTime - prevProcessCpuTime;
        long elapsedTime = upTime - prevUpTime;
        prevProcessCpuTime = processCpuTime;
        prevUpTime = upTime;
        int cpuNumber = mxbean.getAvailableProcessors();
        float cpuUsage = Math.min(99.0f, (float)elapsedCpu / ((float)elapsedTime * 10000.0f * (float)cpuNumber));
        return String.format("[cpuUsage]:%s;", String.valueOf(cpuUsage));
    }

    private Map<String, MXBeanCheck> getMXBeanCheckMap() {
        if (this.mxBeanCheckMap == null) {
            this.mxBeanCheckMap = new ConcurrentHashMap<String, MXBeanCheck>();
            MXBeanCheck mxBeanCheckOld = new MXBeanCheck("old", this.config.getOldGenMemoryLimit());
            this.mxBeanCheckMap.put("old", mxBeanCheckOld);
            MXBeanCheck mxBeanCheckPerm = new MXBeanCheck("perm", this.config.getPermGenMemoryLimit());
            this.mxBeanCheckMap.put("perm", mxBeanCheckPerm);
        }
        return this.mxBeanCheckMap;
    }

    private void checkMXBean() {
        for (MXBeanCheck mxBeanCheck : this.getMXBeanCheckMap().values()) {
            if (!mxBeanCheck.checkError()) continue;
            log.error((Object)"DS will stop cause by memory not enough.");
            FrameInformationManager.getInstance().record("Ds memeroy use", String.format("Checking ds memeroy leave:%d", mxBeanCheck.getUsedPercent()), false);
            FrameInformationManager.printInfo();
            System.exit(0);
        }
    }

    private void updateCacheSize() {
        MXBeanCheck mxBeanCheckOld = this.getMXBeanCheckMap().get("old");
        if (mxBeanCheckOld != null) {
            System.setProperty(MEMORY_OLD_USED_PERCENT, String.valueOf(mxBeanCheckOld.getUsedPercent()));
        }
    }

    private void doCheck(ThreadMXBean tmx) {
        this.checkMXBean();
        this.updateCacheSize();
        ThreadInfo[] infos = tmx.dumpAllThreads(true, true);
        if (this.lastLockMap == null) {
            this.lastLockMap = new ConcurrentHashMap<Long, ThreadData>(infos.length);
        }
        this.updateLockMap(infos);
        this.toCheckLock(infos);
        this.checkThread(infos);
        this.runClean();
    }

    private void checkThread(ThreadInfo[] infos) {
        ThreadChecker[] checkers = ThreadCheckManager.getInstance().getAllCheckers();
        if (checkers.length == 0) {
            return;
        }
        for (ThreadChecker checker : checkers) {
            if (!checker.check()) {
                this.failedCheckThreadMap.remove(checker);
                continue;
            }
            log.error((Object)("thread checked failed, name=" + checker.getThreadName()));
            if (!this.failedCheckThreadMap.containsKey(checker)) {
                this.failedCheckThreadMap.put(checker, new Integer(1));
                continue;
            }
            int failedCount = this.failedCheckThreadMap.get(checker);
            if (failedCount++ < 5) {
                this.failedCheckThreadMap.put(checker, new Integer(failedCount));
                continue;
            }
            log.error((Object)("one of the threads named " + checker.getThreadName() + " has been terminated over 5 minutes!"));
            this.shutdown(infos, checker);
        }
    }

    private void shutdown(ThreadInfo[] infos, ThreadChecker checker) {
        FrameInformationManager.getInstance().record("Ds thread check failed", String.format("Checking ds thread %s lost, result code:%d", checker.getThreadName(), 4), false);
        StopDsThread stop = new StopDsThread("Stop_ds_thread_check_failed", 30000L);
        stop.start();
        this.logStacks(infos, this.config.getMaxLogStack());
        log.error((Object)String.format("Shutdown system for thread named %s checked failed for 5 times.", checker.getThreadName()));
    }

    private void toCheckLock(ThreadInfo[] infos) {
        int[] pool_block = new int[Config.PoolName.length];
        int block60Minutes = 0;
        int block30Minutes = 0;
        int shutdownReason = 0;
        Iterator<Map.Entry<Long, ThreadData>> it = this.lastLockMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ThreadData> entry = it.next();
            if (!entry.getValue().updated) {
                it.remove();
                continue;
            }
            entry.getValue().updated = false;
            if (entry.getValue().belongPool != -1 && entry.getValue().lastBlockedTimeoutTimes >= 10L) {
                int n = entry.getValue().belongPool;
                pool_block[n] = pool_block[n] + 1;
            }
            if (entry.getValue().lastBlockedTimeoutTimes > 60L) {
                ++block60Minutes;
                continue;
            }
            if (entry.getValue().lastBlockedTimeoutTimes <= 30L) continue;
            ++block30Minutes;
        }
        if (block60Minutes >= 1) {
            shutdownReason = 2;
        } else if (block30Minutes >= 3) {
            shutdownReason = 3;
        } else {
            for (int i = 0; i < pool_block.length; ++i) {
                if (pool_block[i] < Config.PoolMAXSET[i]) continue;
                shutdownReason = 1;
                break;
            }
        }
        if (shutdownReason > 0) {
            this.shutdownSystem(infos, shutdownReason);
        }
    }

    private void updateLockMap(ThreadInfo[] infos) {
        for (ThreadInfo info : infos) {
            ThreadData threadData;
            if (info.getThreadState() == Thread.State.BLOCKED) {
                threadData = this.lastLockMap.get(info.getThreadId());
                if (threadData == null) {
                    this.lastLockMap.put(info.getThreadId(), new ThreadData(info.getBlockedCount(), 0L, this.findThreadPool(info)));
                    continue;
                }
                if (info.getBlockedCount() == threadData.lastBlockedCount) {
                    ++threadData.lastBlockedTimeoutTimes;
                } else {
                    threadData.lastBlockedTimeoutTimes = 0L;
                    threadData.lastBlockedCount = info.getBlockedCount();
                }
                threadData.updated = true;
                continue;
            }
            threadData = this.lastLockMap.get(info.getThreadId());
            if (threadData == null) {
                this.lastLockMap.put(info.getThreadId(), new ThreadData(info.getBlockedCount(), 0L, this.findThreadPool(info)));
                continue;
            }
            threadData.lastBlockedTimeoutTimes = 0L;
            threadData.lastBlockedCount = info.getBlockedCount();
            threadData.updated = true;
        }
    }

    private void logStacks(ThreadInfo[] infos, int maxStack) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < infos.length && i < maxStack; ++i) {
            sb.append(Util.toString(infos[i]));
            sb.append('\n');
            sb.append("blockTime: " + infos[i].getBlockedTime());
            if (this.lastLockMap.get(infos[i].getThreadId()) != null) {
                sb.append(" timeout: " + this.lastLockMap.get((Object)Long.valueOf((long)infos[i].getThreadId())).lastBlockedTimeoutTimes);
            }
            sb.append('\n');
            sb.append("waitTime: " + infos[i].getWaitedTime());
            sb.append('\n');
        }
        log.error((Object)sb.toString());
    }

    private ThreadInfo findInfo(ThreadInfo[] infos, long threadId) {
        for (ThreadInfo info : infos) {
            if (info.getThreadId() != threadId) continue;
            return info;
        }
        return null;
    }

    private int findThreadPool(ThreadInfo infor) {
        int index = -1;
        for (int i = 0; i < Config.PoolName.length; ++i) {
            if (infor.getThreadName().indexOf(Config.PoolName[i]) <= -1) continue;
            index = i;
            break;
        }
        return index;
    }

    private static ThreadInfo[] sortThreadInfo(ThreadInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            for (int j = i; j < infos.length; ++j) {
                ThreadInfo infoI = infos[i];
                ThreadInfo infoJ = infos[j];
                if (infoI.getBlockedCount() >= infoJ.getBlockedCount()) continue;
                ThreadInfo infoTemp = infoI;
                infos[i] = infoJ;
                infos[j] = infoTemp;
            }
        }
        return infos;
    }

    private void shutdownSystem(ThreadInfo[] infos, int shutdownReason) {
        FrameInformationManager.getInstance().record("Ds thread deadlock", String.format("Checking ds thread's dead lock, result code:%d", shutdownReason), false);
        infos = WatchDog.sortThreadInfo(infos);
        StopDsThread stop = new StopDsThread("Stop_ds_deadlock", 30000L);
        stop.start();
        this.logStacks(infos, this.config.getMaxLogStack());
        switch (shutdownReason) {
            case 1: {
                log.error((Object)"Shutdown system for find thread pool blocked.");
                break;
            }
            case 3: {
                log.error((Object)"Shutdown system for find more than 3 thread block more than 30 minutes.");
                break;
            }
            case 2: {
                log.error((Object)"Shutdown system for find some thread block more than 60 minutes.");
            }
        }
    }

    private void runClean() {
        boolean needRunGC;
        int hours = Calendar.getInstance().get(11);
        int mins = Calendar.getInstance().get(12);
        boolean bl = needRunGC = (hours == 12 || hours == 24) && mins < 4;
        if (needRunGC) {
            new Thread("Clean_Thread"){

                @Override
                public void run() {
                    log.info((Object)"start runClean.");
                    CleanManagement.getInstance().run();
                    System.gc();
                    log.info((Object)"runClean finish.");
                }
            }.start();
        }
    }
}

