/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.watchdog;

import com.swimap.base.framework.watchdog.IMXBeanCheckHelper;
import com.swimap.base.framework.watchdog.MXBeanCheckHelper;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MXBeanCheck {
    private static Log log = LogFactory.getLog(MXBeanCheck.class);
    private String name = null;
    private long memoryMinSize = 0L;
    private int leakTimes = 0;
    private int needExitTimes = 2;
    private long usedPercent = 0L;
    private IMXBeanCheckHelper helper = new MXBeanCheckHelper();
    private MemoryPoolMXBean memoryPoolMXBean;

    public MXBeanCheck(String name, long minSize) {
        this.name = name;
        this.memoryMinSize = minSize;
    }

    void setHelper(IMXBeanCheckHelper helper) {
        this.helper = helper;
    }

    private IMXBeanCheckHelper getHelper() {
        if (this.helper == null) {
            this.helper = new MXBeanCheckHelper();
        }
        return this.helper;
    }

    public String getName() {
        return this.name;
    }

    private MemoryPoolMXBean getMemoryPoolMXBean() {
        if (this.memoryPoolMXBean == null) {
            List<MemoryPoolMXBean> list = this.getHelper().getMXBeanList();
            for (MemoryPoolMXBean memoryPoolMXBeanTemp : list) {
                try {
                    String beanName = memoryPoolMXBeanTemp.getName().toLowerCase();
                    if (beanName.indexOf(this.name.toLowerCase()) < 0) continue;
                    this.memoryPoolMXBean = memoryPoolMXBeanTemp;
                    break;
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
        return this.memoryPoolMXBean;
    }

    public boolean checkError() {
        boolean isMemoryEnough;
        MemoryPoolMXBean memoryPoolMXBean = this.getMemoryPoolMXBean();
        long memoryMax = memoryPoolMXBean.getUsage().getMax();
        long memoryUsed = memoryPoolMXBean.getUsage().getUsed();
        long memoryLeave = memoryMax - memoryUsed;
        this.usedPercent = memoryUsed * 100L / memoryMax;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("DS memory(%s) memoryLeave %s memoryMax %s usedPercent %s", this.name, memoryLeave, memoryMax, this.usedPercent));
        }
        boolean bl = isMemoryEnough = memoryLeave >= this.memoryMinSize;
        if (!isMemoryEnough) {
            ++this.leakTimes;
            log.error((Object)String.format("DS memory(%s) is not enough, current size has less than %s, times = %s", this.name, memoryLeave, this.leakTimes));
            System.gc();
        } else if (this.leakTimes != 0) {
            this.leakTimes = 0;
            log.error((Object)String.format("DS memory(%s) restore enough.", this.name));
        }
        return this.leakTimes >= this.needExitTimes;
    }

    public long getUsedPercent() {
        return this.usedPercent;
    }
}

