/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.watchdog;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Config {
    public static final String CHECK_INTERVAL_KEY = "imap.watchdog.checkInterval";
    public static final String POOL_TIMEOUT_KEY = "imap.watchdog.poolTimeout";
    public static final String Watchdog_Enable = "enablewatchdog";
    private static final String MAX_LOG_STACK_KEY = "imap.watchdog.maxLogStack";
    private static final String ADDTIONAL_IGNORE_LOCKS_KEY = "imap.watchdog.ignoredLocks";
    public static final int DEFAULT_CHECK_INTERVAL = 60000;
    private static final int DEFAULT_MAX_LOG_STACK = Integer.MAX_VALUE;
    public static final int MAX_LOCK_TIMEOUT = 60;
    public static final int MAX_LOCK_THREAD = 1;
    public static final int MIDDILE_LOCK_TIMEOUT = 30;
    public static final int MIDDILE_LOCK_THREAD = 3;
    public static final int POOL_LOCK_TIMEOUT = 10;
    public static final String OLD_GEN_MEMORY_LIMIT_KEY = "ds.oldgenless";
    public static final int OLD_GEN_MEMORY_LIMIT = 0x200000;
    public static final String PERM_GEN_MEMORY_LIMIT_KEY = "ds.permgenless";
    public static final int PERM_GEN_MEMORY_LIMIT = 0x200000;
    private static final String[] ignoreLockNames = new String[]{"java.util.TaskQueue", "java.lang.ref.ReferenceQueue$Lock", "java.lang.ref.Reference$Lock", "java.util.concurrent.locks.AbstractQueuedSynchronizer$ConditionObject", "java.util.concurrent.SynchronousQueue$TransferStack", "com.swimap.base.rpc.nio.QueuedThreadPool$PoolThread"};
    public static final String[] PoolName = new String[]{"accept_pool", "MrbServer_pool", "MsgDispatch_pool", "read_pool", "task_pool"};
    public static final int[] PoolMAXSET = new int[]{5, 10, 10, 10, 50};
    private final int checkInterval = Integer.getInteger("imap.watchdog.checkInterval", 60000);
    private final int maxLogStack = Integer.getInteger("imap.watchdog.maxLogStack", Integer.MAX_VALUE);
    private final Set<String> ignoredLockSet = new HashSet<String>(Arrays.asList(ignoreLockNames));
    private long oldGenLimit = 0L;
    private long permGenLimit = 0L;

    public Config() {
        this.addIgnoredLocks();
    }

    private void addIgnoredLocks() {
        String[] names;
        String lockNameProperty = System.getProperty(ADDTIONAL_IGNORE_LOCKS_KEY);
        if (lockNameProperty == null) {
            return;
        }
        for (String name : names = lockNameProperty.split(",")) {
            String lockName = name.trim();
            if (lockName.length() <= 0) continue;
            this.ignoredLockSet.add(lockName);
        }
    }

    public final boolean isWatchdogEnable() {
        String watchdogEnable = System.getProperty(Watchdog_Enable);
        if (watchdogEnable != null) {
            return Boolean.getBoolean(Watchdog_Enable);
        }
        return true;
    }

    public final long getOldGenMemoryLimit() {
        if (this.oldGenLimit != 0L) {
            return this.oldGenLimit;
        }
        long limit = Long.getLong(OLD_GEN_MEMORY_LIMIT_KEY, 0L);
        this.oldGenLimit = limit < 0x200000L ? 0x200000L : limit;
        return this.oldGenLimit;
    }

    public final long getPermGenMemoryLimit() {
        if (this.permGenLimit != 0L) {
            return this.permGenLimit;
        }
        long limit = Long.getLong(PERM_GEN_MEMORY_LIMIT_KEY, 0L);
        this.permGenLimit = limit < 0x200000L ? 0x200000L : limit;
        return this.permGenLimit;
    }

    public final int getCheckInterval() {
        return this.checkInterval;
    }

    public final int getMaxLogStack() {
        return this.maxLogStack;
    }

    public final boolean isIgnoredLock(String lockName) {
        return this.ignoredLockSet.contains(lockName);
    }
}

