/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.monitor;

import com.swimap.base.framework.monitor.ExceptionKpi;
import com.swimap.base.framework.monitor.Kpi;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KpiManagement {
    private static Log log = LogFactory.getLog(KpiManagement.class);
    private Map<String, Map<String, Kpi>> kpis = new ConcurrentHashMap<String, Map<String, Kpi>>();
    public static final Kpi EXCEPTION_KPI = new ExceptionKpi();
    static KpiManagement instance = new KpiManagement();

    private KpiManagement() {
    }

    public static synchronized KpiManagement getInstance() {
        return instance;
    }

    public void registerKpi(String module, List<Kpi> kpiList) {
        if (!this.kpis.containsKey(module = module.toLowerCase())) {
            this.kpis.put(module, new ConcurrentHashMap());
        }
        Map<String, Kpi> map = this.kpis.get(module);
        for (Kpi kpi : kpiList) {
            String name = kpi.getName().toLowerCase();
            map.put(kpi.getName().toLowerCase(), kpi);
        }
    }

    public void registerKpi(String module, Kpi kpi) {
        Vector<Kpi> kpiList = new Vector<Kpi>();
        kpiList.add(kpi);
        this.registerKpi(module, kpiList);
    }

    public Kpi getKpi(String kpiKey) {
        for (Map<String, Kpi> map : this.kpis.values()) {
            if (!map.containsKey(kpiKey = kpiKey.trim().toLowerCase())) continue;
            Kpi kpi = map.get(kpiKey);
            return kpi;
        }
        return EXCEPTION_KPI;
    }

    public List<Kpi> getAllKpi() {
        Vector<Kpi> list = new Vector<Kpi>();
        for (Map<String, Kpi> map : this.kpis.values()) {
            list.addAll(map.values());
        }
        return list;
    }

    public synchronized String getKpiInformation(String moduleName) {
        if (moduleName == null) {
            Iterator<String> names = this.kpis.keySet().iterator();
            StringBuffer s = new StringBuffer("<html><table border=1 align=left  width=1000>");
            while (names.hasNext()) {
                String name = names.next();
                s.append("<tr><td colspan=4><center><b>").append(name).append("</b></center>");
                s.append("<tr>");
                s.append("<th align=left>Name</th>").append("<th align=left>Values</th>").append("<th align=left>Description</th>");
                Map<String, Kpi> kpiLst = this.kpis.get(name);
                for (Kpi kpi : kpiLst.values()) {
                    String value = null;
                    try {
                        value = kpi.getKpiValue();
                    }
                    catch (Exception e) {
                        value = "Exception";
                    }
                    if (value == null) {
                        value = "NA";
                    }
                    s.append("<tr>");
                    s.append("<td>").append(kpi.getName()).append("<td>");
                    s.append(value).append("<td>");
                    s.append(kpi.getDescription());
                }
                s.append("<tr>");
            }
            s.append("</table></html>");
            return s.toString();
        }
        Map<String, Kpi> kpiLst = this.kpis.get(moduleName.toLowerCase());
        if (kpiLst == null || kpiLst.size() == 0) {
            return "No result for your request.";
        }
        StringBuffer s = new StringBuffer("<html><table border=1 align=left  width=1000>");
        s.append("<tr><td colspan=4><center><b>").append(moduleName).append("</b></center>");
        s.append("<tr>");
        s.append("<th align=left>Name</th>").append("<th align=left>Values</th>").append("<th align=left>Description</th>");
        for (Kpi kpi : kpiLst.values()) {
            String value = null;
            try {
                value = kpi.getKpiValue();
            }
            catch (Exception e) {
                value = "Exception";
            }
            if (value == null) {
                value = "NA";
            }
            s.append("<tr>");
            s.append("<td>").append(kpi.getName()).append("<td>");
            s.append(value).append("<td>");
            s.append(kpi.getDescription());
        }
        s.append("<tr>");
        s.append("</table></html>");
        return s.toString();
    }
}

