/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.monitor;

import com.swimap.base.framework.monitor.AgentManager;
import com.swimap.base.framework.monitor.DataCollectAgent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataDump {
    private static Log log = LogFactory.getLog(DataDump.class);
    private String outputDir;
    private static DataDump instance = new DataDump();
    AgentManager am = AgentManager.getInstance();

    private DataDump() {
        this.initOutputDir();
    }

    public static DataDump getInstance() {
        return instance;
    }

    private String getFilename(String fieldName) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
        return this.outputDir + File.separatorChar + fieldName + "_" + format.format(new Date()) + ".dat";
    }

    private void initOutputDir() {
        boolean result;
        String home = System.getProperty("imap.home");
        String instance = System.getProperty("imap.config");
        this.outputDir = home + File.separatorChar + "var" + File.separatorChar + "com.swimap.base.framework.monitor" + File.separatorChar + "dump" + File.separatorChar + instance;
        File dir = new File(this.outputDir);
        if (!dir.exists() && !(result = dir.mkdirs())) {
            log.fatal((Object)"debug dump diretory create failed");
        }
    }

    public static File createNewFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!(file.exists() && file.isFile() || file.createNewFile())) {
            log.error((Object)"createNewFile failed.");
            throw new IOException("can't create new file, fileName: " + fileName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(String fieldName, String agent) {
        DataCollectAgent ddAgent = this.am.getDataCollectAgent(agent);
        if (ddAgent == null) {
            return agent + " not Exist";
        }
        String fileName = this.getFilename(fieldName);
        OutputStream os = null;
        try {
            DataDump.createNewFile(fileName);
            os = new FileOutputStream(fileName);
            String result = ddAgent.dump(os);
            os.flush();
            String string = "Dump data " + agent + " to file" + fileName + " result:" + result;
            return string;
        }
        catch (FileNotFoundException e) {
            String string = e.toString();
            return string;
        }
        catch (IOException e) {
            String string = e.toString();
            return string;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }
}

