/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.base.framework.dao;

import com.swimap.base.framework.dao.DataSourceManager;
import com.swimap.base.framework.dao.DataSourceProxy;
import com.swimap.base.framework.dao.TableCopyListener;
import com.swimap.base.framework.dao.TableCopyTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableCopier {
    private static final Log log = LogFactory.getLog(TableCopier.class);
    private static final int DEFAULT_BATCH_SIZE = 500;
    private static final int DEFAULT_BATCH_IN_TRANS = 10;
    private int batchSize = 500;
    private int batchInTrans = 10;
    private String name;
    private DataSource source;
    private DataSource target;
    private ArrayList<TableCopyTask> tasks = new ArrayList();
    private TableCopyListener listener;
    private boolean running;
    private DataSourceProxy proxy;

    public TableCopier(String srcDsName, String tagDsName) {
        this(srcDsName + "->" + tagDsName, DataSourceManager.instance().getDataSource(srcDsName), DataSourceManager.instance().getDataSource(tagDsName));
    }

    public TableCopier(String name, DataSource source, DataSource target) {
        if (source == null) {
            throw new IllegalArgumentException("Null source DataSource");
        }
        if (target == null) {
            throw new IllegalArgumentException("Null target DataSource");
        }
        this.name = name;
        this.source = source;
        this.target = target;
        this.proxy = new DataSourceProxy(source);
    }

    public void setListener(TableCopyListener listener) {
        this.listener = listener;
    }

    public void addTask(TableCopyTask task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    public void setBatchInTrans(int batchInTrans) {
        this.batchInTrans = batchInTrans;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getName() {
        return this.name;
    }

    public DataSource getDataSourceProxy() {
        return this.proxy;
    }

    public DataSource getSource() {
        return this.source;
    }

    public DataSource getTarget() {
        return this.target;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        Thread copyThread = new Thread(){

            @Override
            public void run() {
                TableCopier.this.doCopyJob();
            }
        };
        this.running = true;
        copyThread.setDaemon(true);
        copyThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyJob() {
        this.logInfo("table copy started.");
        long start = System.currentTimeMillis();
        try {
            this.notifyCopyBegin();
            this.copyTables();
            this.notifyCopyDone();
            this.proxy.setDataSource(this.target);
            long ms = System.currentTimeMillis() - start;
            this.logInfo("table copy done. use " + ms + " ms");
        }
        catch (Exception e) {
            this.notifyCopyFailed(e);
            this.logWarn("table copy failed.", e);
        }
        finally {
            this.running = false;
        }
    }

    private void copyTables() throws SQLException {
        Connection srcConn = null;
        Connection dstConn = null;
        try {
            srcConn = this.source.getConnection();
            dstConn = this.target.getConnection();
            if (dstConn == null || srcConn == null) {
                throw new SQLException("conn null");
            }
            dstConn.setAutoCommit(false);
            for (TableCopyTask task : this.tasks) {
                long start = System.currentTimeMillis();
                int rows = this.doTableCopyTask(task, srcConn, dstConn);
                long ms = System.currentTimeMillis() - start;
                this.logInfo("table '" + task.getTableName() + "' copied, " + rows + " row(s), use " + ms + " ms.");
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            if (dstConn != null) {
                dstConn.rollback();
            }
            throw new SQLException(e);
        }
        finally {
            try {
                if (dstConn != null && !dstConn.isClosed()) {
                    dstConn.setAutoCommit(true);
                    dstConn.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"", (Throwable)e);
            }
            try {
                if (srcConn != null && !srcConn.isClosed()) {
                    srcConn.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
    }

    private void notifyCopyBegin() throws Exception {
        if (this.listener != null) {
            this.listener.tableCopyPrepare(this);
        }
    }

    private void notifyCopyDone() {
        if (this.listener != null) {
            this.listener.tableCopyDone(this);
            this.listener = null;
        }
    }

    private void notifyCopyFailed(Exception e) {
        if (this.listener != null) {
            this.listener.tableCopyFailed(this, e);
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doTableCopyTask(TableCopyTask task, Connection srcConn, Connection dstConn) throws SQLException {
        Statement stm = null;
        ResultSet rs = null;
        Statement ps = null;
        int batchCount = 0;
        int noCommitedBatch = 0;
        int rowCount = 0;
        try {
            String sql = task.getSelectStatement();
            this.logInfo(sql);
            stm = srcConn.createStatement();
            rs = stm.executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            sql = this.getInsertStatement(task, meta);
            this.logInfo(sql);
            ps = dstConn.prepareStatement(sql);
            while (rs.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = rs.getObject(i);
                    if (value != null) {
                        ps.setObject(i, value);
                        continue;
                    }
                    ps.setNull(i, meta.getColumnType(i));
                }
                ps.addBatch();
                if (++batchCount == this.batchSize) {
                    ps.executeBatch();
                    ps.clearBatch();
                    batchCount = 0;
                    if (++noCommitedBatch == this.batchInTrans) {
                        dstConn.commit();
                        noCommitedBatch = 0;
                    }
                }
                ++rowCount;
            }
            ps.executeBatch();
            dstConn.commit();
            int n = rowCount;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception sqlE) {
                log.warn((Object)"", (Throwable)sqlE);
            }
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception sqlE) {
                log.warn((Object)"", (Throwable)sqlE);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception sqlE) {
                log.warn((Object)"", (Throwable)sqlE);
            }
        }
    }

    private void logInfo(String info) {
    }

    private void logWarn(String warn, Exception e) {
        log.warn((Object)('[' + this.name + "] " + warn), (Throwable)e);
    }

    private String getInsertStatement(TableCopyTask task, ResultSetMetaData meta) throws SQLException {
        int i;
        int columnCount = meta.getColumnCount();
        StringBuilder sql = new StringBuilder("insert into " + task.getTableName());
        sql.append("(");
        for (i = 1; i <= columnCount; ++i) {
            if (i > 1) {
                sql.append(",");
            }
            sql.append(meta.getColumnName(i));
        }
        sql.append(") values (");
        for (i = 1; i <= columnCount; ++i) {
            if (i > 1) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    public String toString() {
        return "TableCopier [" + this.getName() + ']';
    }
}

